<?php
/**
 * Title: FAQ
 * Slug: flexia/faq
 * Categories: flexia
 */
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|x-small","right":"var:preset|spacing|x-small"},"blockGap":"var:preset|spacing|medium"}},"backgroundColor":"secondary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-secondary-background-color has-background" style="padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--x-small)"><!-- wp:heading {"textAlign":"center","style":{"typography":{"textTransform":"capitalize"}},"fontSize":"large-plus"} -->
<h2 class="wp-block-heading has-text-align-center has-large-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'Frequently Asked Questions', 'Message to convey FAQ', 'flexia' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"20px"} -->
<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":4,"style":{"typography":{"textTransform":"capitalize"}},"fontSize":"medium-plus"} -->
<h4 class="wp-block-heading has-medium-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'How do I get updates?', 'Message to convey FAQ', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html_x( 'You will get automatic update for Flexia from wp.org. If Flexia Pro is validated, you will get the automatic update in the same way, right from your WordPress Dashboard.', 'Message to convey FAQ', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"className":"is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":4,"style":{"typography":{"textTransform":"capitalize"},"elements":{"link":{"color":{"text":"var:preset|color|text"}}}},"textColor":"text","fontSize":"medium-plus"} -->
<h4 class="wp-block-heading has-text-color has-link-color has-medium-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'What is the difference between "Annual" and "Lifetime"?', 'Message to convey FAQ', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html_x( 'For annual license, you will receive premium support and automatic updates for 1 year. You will need to renew your license to avail them. For lifetime license, you get everything for lifetime!', 'Message to convey FAQ', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"className":"is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":4,"style":{"typography":{"textTransform":"capitalize"}},"fontSize":"medium-plus"} -->
<h4 class="wp-block-heading has-medium-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'What if I don\'t renew my annual license?', 'Message to convey FAQ', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html_x( 'If you don\'t renew, you won\'t get the premium support and automatic updates. But you can always get the latest version from your account, download them and update manually.', 'Message to convey FAQ', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"className":"is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-swt-separator-wide-thin-line is-style-flexia-separator-wide-thin-line" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":4,"style":{"typography":{"textTransform":"capitalize"}},"fontSize":"medium-plus"} -->
<h4 class="wp-block-heading has-medium-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'Responsive & Dynamic', 'Message to convey FAQ', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html_x( 'Pixel perfect responsiveness with modern Flexbox and Bootstrap 4 grid to make it perfect responsiveness for all devices.', 'Message to convey FAQ', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->