<!--===// Start: Main Header
=================================-->
<?php 		
	$hide_show_offer_code 	=	get_theme_mod('hide_show_offer_code','1');		
	$hdr_offer_code_lbl 	=	get_theme_mod('hdr_offer_code_lbl');
	
	$hide_show_contact_us 	=	get_theme_mod('hide_show_contact_us','1');		
	$hdr_contact_us_title 	=	get_theme_mod('hdr_contact_us_title');		
	$hdr_contact_us_number 	=	get_theme_mod('hdr_contact_us_number');		
	$hdr_contact_us_icon 	=	get_theme_mod('hdr_contact_us_icon','fa fa-phone');		
?>	
<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php echo esc_url(get_header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- START: HEADER -->
<header id="main-header3" class="main-header">
	<?php do_action('flossy_above_header');?>
	<!-- Middle Area -->
	<div class="middle-wrapper d-none d-lg-block">
		<div class="container">
			<div class="row navigation-middle-row align-items-center">
				<div class="col-lg-3 col-12 ">
					<div class="logo">
						<?php do_action('flossy_logo'); ?>
					</div>
				</div>

				<div class="col-lg-6 col-12">
					<?php do_action('flossy_hdr_product_search')?>
				</div>

				<div class="col-lg-3 col-12">
					<div class="main-menu-right">
						<ul class="menu-right-list">
							<?php
								do_action('flossy_hdr_cart');
								do_action('flossy_hdr_account');
							?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End: Middle Area -->

	<!-- NAVIGATION-AREA -->
	<div class="navigation-wrapper">
		<div class="navigation-bottom">
			<div class="main-navigation-area d-none d-lg-block">
				<div class="main-navigation <?php echo flossy_sticky_menu(); ?>">
					<div class="container">
						<div class="row navigation-bottom-row transparent">
							<div class="col-3">
								<?php if($hide_show_contact_us=='1'){ ?>
									<div class="contact-call-wrapper">
										<div class="icon-wrapper"><i class="fa <?php echo esc_attr($hdr_contact_us_icon); ?>"></i></div>
										<div class="contact-info-text">
											<div>
												<?php echo esc_html($hdr_contact_us_title); ?>
											</div>
											<a href="tel:<?php echo esc_attr(str_replace(' ','',$hdr_contact_us_number)); ?>"><?php echo esc_html($hdr_contact_us_number); ?></a>
										</div>
									</div>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 d-flex align-items-center">
								<nav class="navbar-area w-100">
									<div class="main-navbar">
										<?php do_action('flossy_main_nav'); ?>
									</div>
									
									<?php if($hide_show_offer_code == '1'){ ?>
										<div class="coupon-code">
											<i class="fa fa-gift" aria-hidden="true"></i>
											<span class="text-coupon"><?php echo esc_html__('Coupon Code:','flexi-mart'); ?> <span><?php echo esc_html($hdr_offer_code_lbl); ?></span></span>
										</div>
									<?php } ?>
								</nav>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="main-mobile-nav <?php echo flossy_sticky_menu(); ?> d-lg-none">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="main-mobile-menu">
							<div class="menu-collapse-wrap">
								<div class="hamburger-menu">
									<button type="button" class="menu-collapsed" aria-label="Menu Collaped">
										<div class="top-bun"></div>
										<div class="meat"></div>
										<div class="bottom-bun"></div>
									</button>
								</div>
							</div>
							<div class="mobile-logo">
								<div class="logo d-flex justify-content-center align-items-center">
									<?php do_action('flossy_logo'); ?>
								</div>
							</div>

							<div class="main-mobile-wrapper">
								<div id="mobile-menu-build" class="main-mobile-build">
								<?php 
									$hs_product_search	= get_theme_mod( 'hs_product_search','1');
									if($hs_product_search=='1'){
								?>										
									<?php do_action('flossy_hdr_normal_search'); 
									}	
								?>
									<button type="button" class="header-close-menu close-style"
										aria-label="Header Close Menu"></button>
									<?php do_action('flossy_hdr_mobile_browse_cat')?>
								</div>
							</div>
							<div class="mobile-menu-right">
								<ul class="header-wrap-right"></ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>
<!-- END:HEADER -->
<?php 

	if ( !is_page_template(  'templates/template-homepage.php' ) ) {	
		flossy_breadcrumbs_style();  
	}	
?>