<?php
/**
 * The template used for displaying featured pages on the Front Page.
 *
 * @package Fleming
 */

$page_ids = array();
if ( absint(get_theme_mod( 'fleming-featured-page-1', false )) != 0 ) { $page_ids[] = absint(get_theme_mod( 'fleming-featured-page-1', false )); }
if ( absint(get_theme_mod( 'fleming-featured-page-2', false )) != 0 ) { $page_ids[] = absint(get_theme_mod( 'fleming-featured-page-2', false )); }
if ( absint(get_theme_mod( 'fleming-featured-page-3', false )) != 0 ) { $page_ids[] = absint(get_theme_mod( 'fleming-featured-page-3', false )); }
if ( absint(get_theme_mod( 'fleming-featured-page-4', false )) != 0 ) { $page_ids[] = absint(get_theme_mod( 'fleming-featured-page-4', false )); }
if ( absint(get_theme_mod( 'fleming-featured-page-5', false )) != 0 ) { $page_ids[] = absint(get_theme_mod( 'fleming-featured-page-5', false )); }
$page_count = 0;
$page_count = count($page_ids);

$slideshow_palette 	= get_theme_mod( 'theme-slideshow-palette', 'dark' );
$slideshow_speed 	= absint(get_theme_mod( 'theme-slideshow-speed', 0 ));

if ( $page_count > 0 ) {
	$custom_loop = new WP_Query( array( 'post_type' => 'page', 'post__in' => $page_ids, 'orderby' => 'post__in' ) );

	if ( $custom_loop->have_posts() ) : ?>

	<div class="site-section-wrapper site-section-wrapper-slideshow site-section-wrapper-slideshow-large">
		<div id="site-section-slideshow" class="site-flexslider site-flexslider-<?php echo esc_attr($slideshow_palette); ?>" style="visibility:hidden;">
			<ul class="site-slideshow-list academia-slideshow">
				<?php
				$i = 0;
				while ( $custom_loop->have_posts() ) : $custom_loop->the_post();
				$i++;
				$fetchpriority = 'auto';
				if ( $i == 1 ) {
					$fetchpriority = 'high';
				}
				?>
				<li class="site-slideshow-item"<?php if ( $i > 1 ) { echo ' style="display: none;"';} ?>>
					<?php if ( has_post_thumbnail( $post->ID ) ) {
						the_post_thumbnail('thumb-academia-slideshow', array('loading' => 'eager', 'fetchpriority' => $fetchpriority));
					}
					?>
					<div class="slideshow-item-content-wrapper">
						<?php the_title( sprintf( '<h1 class="hero-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>
						<p class="hero-description"><?php echo wp_kses_post(get_the_excerpt()); ?></p>
						<span class="hero-button-span"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="hero-button-anchor"><?php esc_html_e('Read More','fleming'); ?></a></span>
					</div><!-- .slideshow-item-content-wrapper -->
				</li><!-- .site-slideshow-item -->
				<?php 
				endwhile; 
				?>
			</ul><!-- .site-slideshow-list .academia-slideshow -->
		</div><!-- #site-section-slideshow -->
	</div><!-- .site-section-wrapper .site-section-wrapper-slideshow -->

	<?php if ( $page_count > 1 ) { ?>
		<script type="text/javascript">
		jQuery(document).ready(function() {
			
			jQuery(".site-flexslider").flexslider({
				selector: ".site-slideshow-list > .site-slideshow-item",
				animation: "slide",
				animationLoop: true,
				initDelay: 500,
				smoothHeight: true,
				slideshow: <?php if ( $slideshow_speed != '0' ) { echo 'true'; } else { echo 'false'; } ?>,
				slideshowSpeed: <?php echo esc_attr($slideshow_speed); ?>,
				pauseOnAction: true,
				pauseOnHover: false,
				controlNav: true,
				directionNav: true,
				useCSS: true,
				touch: false,
				animationSpeed: 500,
				rtl: false,
				reverse: false,
				prevText: '<span class="icon-icomoon academia-icon-chevron-left"></span>',
				nextText: '<span class="icon-icomoon academia-icon-chevron-right"></span>',
				start: function(slider) { slider.addClass('site-flexslider-loaded'); }
			});
		
		});
		</script>
	<?php } ?>

<?php else : ?>

 <?php if ( current_user_can( 'publish_posts' ) && is_customize_preview() ) : ?>

	<div class="site-section-wrapper site-section-wrapper-slideshow site-section-wrapper-slideshow-large">
		<div id="site-section-slideshow">

			<div class="fleming-page-intro fleming-nofeatured">
				<h1 class="title-page"><?php esc_html_e( 'No Featured Pages Found', 'fleming' ); ?></h1>
				<div class="taxonomy-description">

					<p><?php printf( esc_html__( 'This section will display your featured pages. Configure (or disable) it via the Customizer.', 'fleming' ) ); ?></p>
					<p><strong><?php printf( esc_html__( 'Important: This message is NOT visible to site visitors, only to admins and editors.', 'fleming' ) ); ?></strong></p>

				</div><!-- .taxonomy-description -->
			</div><!-- .fleming-page-intro .fleming-nofeatured -->

		</div><!-- #site-section-slideshow -->
	</div><!-- .site-section-wrapper .site-section-wrapper-slideshow -->

<?php endif; ?>

<?php
	endif;
}