<?php
/**
 * Display Social Links
 *
 * @since Fitness Hub 1.0.0
 *
 * @param null
 * @return void
 */
if ( ! function_exists( 'fitness_hub_social_links' ) ) :

	function fitness_hub_social_links() {

		$fitness_hub_customizer_all_values = fitness_hub_get_theme_options();
		$fitness_hub_social_data           = json_decode( $fitness_hub_customizer_all_values['fitness-hub-social-data'] );
		if ( is_array( $fitness_hub_social_data ) ) {
			echo '<ul class="socials at-display-inline-block">';
			foreach ( $fitness_hub_social_data as $social_data ) {
				$icon     = $social_data->icon;
				$link     = $social_data->link;
				$checkbox = $social_data->checkbox;
				echo '<li>';
				echo '<a href="' . esc_url( $link ) . '" target="' . ( $checkbox == 1 ? '_blank' : '' ) . '">';
				echo '<i class="fa ' . esc_attr( $icon ) . '"></i>';
				echo '</a>';
				echo '</li>';
			}
			echo '</ul>';
		}
	}
endif;
add_action( 'fitness_hub_action_social_links', 'fitness_hub_social_links', 10 );

if ( ! function_exists( 'fitness_hub_action_top_menu' ) ) :

	function fitness_hub_action_top_menu() {
		echo "<div class='at-first-level-nav at-display-inline-block text-right'>";
		wp_nav_menu(
			array(
				'theme_location' => 'top-menu',
				'container'      => false,
				'depth'          => 1,
			)
		);
		echo '</div>';
	}
endif;
add_action( 'fitness_hub_action_top_menu', 'fitness_hub_action_top_menu', 10 );
