<?php
//---------------------------------------------
// Theme Customize 
//---------------------------------------------

add_action( 'customize_register', 'firnera_lite_customizer_register' );
function firnera_lite_customizer_register($wp_customize) {

	//-------------------------------
	//-------------------------------
	//	SANITIZATION FUNCTIONS
	//-------------------------------
	//-------------------------------
	


    //checkbox sanitization function
        function firnera_sanitize_checkbox( $input ) {
	
			// Boolean check 
			return ( ( isset( $input ) && true == $input ) ? true : false );
		}
	
	// Add postMessage support for site title and description.
	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	
	/**
	 * Render the site title for the selective refresh partial.
	 */
	function firnera_lite_customize_partial_blogname() {
		bloginfo( 'name' );
	}


	/**
	 * Render the site tagline for the selective refresh partial.
	 */
	function firnera_lite_customize_partial_blogdescription() {
		bloginfo( 'description' );
	}



//-------------------------------------------
// Add Panel General Options
//-------------------------------------------

	$wp_customize->add_panel( 'firnera_lite_customizer_panel_general_option', array(
    'title'    => esc_html__('General Options', 'firnera-lite'),
    'description' => esc_html__('General Options', 'firnera-lite'),
    'priority' => 14,
	));

	// Header Section
	$wp_customize->add_section( 'firnera_lite_customizer_header_social_url_section', array(
		'title' => esc_html__( 'Header Social URL Setting', 'firnera-lite' ),
		'priority' => 3,
		'panel' => 'firnera_lite_customizer_panel_general_option',
	));	
	// Facebook URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_fb', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_fb', array(
    	'label' => esc_html__('Facebook URL','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_fb'
	));	

	// Twitter URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_twitter', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_twitter', array(
    	'label' => esc_html__('Twitter / X URL','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_twitter'
	));	

	// Pinterest URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_pinterest', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_pinterest', array(
    	'label' => esc_html__('Pinterest URL','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_pinterest'
	));	

	// Youtube URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_youtube', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_youtube', array(
    	'label' => esc_html__('Youtube URL','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_youtube'
	));


	// Youtube URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_instagram', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_instagram', array(
    	'label' => esc_html__('Instagram URL','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_instagram'
	));

	// RSS FEED URL
	$wp_customize->add_setting( 'firnera_lite_customizer_input_social_url_RSS', array(
    	'sanitize_callback' => 'esc_url_raw',
	));
	$wp_customize->add_control( 'firnera_lite_customizer_input_social_url_RSS', array(
    	'label' => esc_html__('RSS FEED','firnera-lite' ),
    	'type' => 'url',
    	'section' => 'firnera_lite_customizer_header_social_url_section',
    	'settings' => 'firnera_lite_customizer_input_social_url_RSS'
	));		

	// Header Section
	$wp_customize->add_section( 'firnera_lite_customizer_header_search_section', array(
		'title' => esc_html__( 'Header Search', 'firnera-lite' ),
		'priority' => 4,
		'panel' => 'firnera_lite_customizer_panel_general_option',
	));	
	// Header Search
	$wp_customize->add_setting( 'firnera_lite_customizer_header_search_enable', array(
    	'sanitize_callback' => 'firnera_sanitize_checkbox',
    	'default' => true,
	));
	$wp_customize->add_control( 'firnera_lite_customizer_header_search_enable', array(
    	'label' => esc_html__('Checkbox to Enable Header Search','firnera-lite' ),
    	'type' => 'checkbox',
    	'section' => 'firnera_lite_customizer_header_search_section',
    	'settings' => 'firnera_lite_customizer_header_search_enable'
	));	

	// selective-refresh option added
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
        'selector' => '.titlesites h1 a',
        'render_callback' => 'firnera_lite_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
        'selector' => '.titlesites h3',
        'render_callback' => 'firnera_lite_customize_partial_blogdescription',
	) );
	
	
	
	} 
	?>