<?php
/**
 * Add Theme Info page to admin menu
 */
function firnera_lite_info_menu_link() {




	add_theme_page(
		sprintf( esc_html__( 'Welcome to %1$s %2$s', 'firnera-lite' ), wp_get_theme()->get( 'Name' ), wp_get_theme()->get( 'Version' ) ),
		esc_html__( 'Theme Info', 'firnera-lite' ),
		'edit_theme_options',
		'firnera-lite',
		'firnera_lite_info_page'
	);

}
add_action( 'admin_menu', 'firnera_lite_info_menu_link' );


function firnera_lite_info_page() {

	
	?>

	<div class="wrap firnera-lite-info-wrapper">

		<h1><?php printf( esc_html__( 'Welcome to %1$s %2$s', 'firnera-lite' ), wp_get_theme()->get( 'Name' ), wp_get_theme()->get( 'Version' ) ); ?></h1>

		<div class="theme-description"><?php echo wp_get_theme()->get( 'Description' ); ?></div>

		<hr>
		<div class="important-links clearfix">
			<p><strong><?php esc_html_e( 'Theme Links', 'firnera-lite' ); ?>:</strong>
				<a href="<?php echo esc_url( __( 'https://wordpress.org/themes/firnera-lite/', 'firnera-lite' ) ); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Theme Page', 'firnera-lite' ); ?></a>
			</p>
		</div>
		<hr>

		<div id="getting-started">

			<h3><?php printf( esc_html__( 'Getting Started with %s', 'firnera-lite' ), wp_get_theme()->get( 'Name' ) ); ?></h3>

			<div class="columns-wrapper clearfix">

				<div class="column column-half clearfix">

					<div class="section">						
						<h4><?php esc_html_e( 'Recommended Plugins', 'firnera-lite' ); ?></h4>
						<p class="about">
							<?php echo esc_html__( 'Some of the recommended plugins, please search for plugin search then install. Some of these plugins are as follows:', 'firnera-lite' ); ?>
							<ul class="firnera-full-list">
								<li><strong><?php echo esc_html('AddToAny Share Buttons - ','firnera-lite'); ?></strong><em><?php echo esc_html__('Used so that users can share pages on social media, etc.','firnera-lite'); ?></em></li>
								<li><strong><?php echo esc_html('Font Awesome - ','firnera-lite'); ?></strong><em><?php echo esc_html__('To display icons in the Theme.','firnera-lite'); ?></em></li>
								<li><strong><?php echo esc_html('Woocommerce - ','firnera-lite'); ?></strong><em><?php echo esc_html__('If you want to sell something online, this plugin makes it possible to sell online.','firnera-lite'); ?></em></li>
								<li><strong><?php echo esc_html('Classic Widgets - ','firnera-lite'); ?></strong><em><?php echo esc_html__('Allows using the Classic Widget, if preferred.','firnera-lite'); ?></em></li>
								<li><strong><?php echo esc_html('Classic Editor - ','firnera-lite'); ?></strong><em><?php echo esc_html__('Allows using the Classic Editor, if preferred.','firnera-lite'); ?></em></li>
							</ul>
						</p>
						<h4><?php esc_html_e( 'Theme Options', 'firnera-lite' ); ?></h4>
						<p class="about">
							<?php printf( esc_html__( '%s theme settings. Click on "Customize Theme" to open the Customizer now.', 'firnera-lite' ), wp_get_theme()->get( 'Name' ) ); ?>
						</p>
						<p>
							<a href="<?php echo esc_url(admin_url( 'customize.php' )); ?>" class="button button-primary"><?php esc_html_e( 'Customize Theme', 'firnera-lite' ); ?></a>
						</p>
					</div>

				</div>

				<div class="column column-half clearfix">

					<img src="<?php echo esc_url(get_template_directory_uri(). '/screenshot.png'); ?>" />

				</div>

			</div>

		</div>

		<hr>

		<div id="more-features">

			<h3><?php esc_html_e( 'Get Full Features', 'firnera-lite' ); ?></h3>

			<div class="columns-wrapper clearfix">

				<div class="column column-half clearfix">

					<div class="section">
						<h4><?php esc_html_e( 'Firnera Full Version Coming soon', 'firnera-lite' ); ?></h4>

						<p class="about">
							<?php echo esc_html__( 'Purchase the Firnera Full Version and get additional features, advanced customization options and Premium Support.','firnera-lite' ); ?>
						</p>
						<p class="about">
						<?php echo esc_html__('In the meantime, Firnera Pro Version is still being updated, if you have purchased Firnera Pro Version in the past, please contact via e-mail fffthemes@gmail.com and include a screenshot of proof of payment, as well as Paypal transaction ID. Then you will get Firnera Pro Version if it has been updated.','firnera-lite'); ?><br><strong><?php echo esc_html__('email : fffthemes@gmail.com','firnera-lite'); ?></strong>
						</p>
					</div>

				</div>

				<div class="column column-half clearfix">

					<div class="section">
						<h4><?php esc_html_e( 'Firnera Full Version Features', 'firnera-lite' ); ?></h4>

							<p class="about">
								<?php esc_html_e( 'Firnera Full Version Features.', 'firnera-lite' ); ?>
								<a href="<?php echo esc_url( __( 'https://firdaus.asia/firnera', 'firnera-lite' ) ); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Get Firnera Full Version', 'firnera-lite' ); ?></a>
							</p>
							<ul class="firnera-full-list">
								<li><?php esc_html_e( 'Custom Color','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Wide or Boxed Layout','firnera-lite' ); ?></li>
								<li><?php esc_html_e( '6 Style Post List','firnera-lite' ); ?></li>
								<li><?php esc_html_e( '6 Style Single','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Related Posts','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Social Shares','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Addons Plugin','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Post Views','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Footer Widget','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Custom Google Font','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Customize Sidebar','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Special Elementor Widget','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Category Image and Background Color','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Premium Support 1 Year, (Can be extended)','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'Free updates forever (as long as the store website still exists)','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'and much more ...','firnera-lite' ); ?></li>
							</ul>
							<p class="about">
								<?php esc_html_e( 'Coming Soon Features', 'firnera-lite' ); ?>
							</p>
							<ul class="firnera-full-list">
								<li><?php esc_html_e( 'More than Layout','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'More than Style Post List','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'More than Style Single','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'More than Header Style','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'More than Elementor Widget','firnera-lite' ); ?></li>
								<li><?php esc_html_e( 'and much more ...','firnera-lite' ); ?></li>
							</ul>
						
					</div>

				</div>

			</div>

		</div>

		<hr>

		<div id="theme-author">
			<p><?php printf( esc_html__( 'Thanks already using %1$s by %2$s. Thanks also to %3$s :)', 'firnera-lite' ),
				wp_get_theme()->get( 'Name' ),
				'<a target="_blank" rel="noopener noreferrer" href="' . __( 'https://firdaus.asia', 'firnera-lite' ) . '" title="Firnera Lite">Firdaus</a>',
				'<a target="_blank" rel="noopener noreferrer" href="' . __( 'https://wordpress.org/', 'firnera-lite' ) . '" title="' . esc_attr__( 'WordPress', 'firnera-lite' ) . '">' . esc_html__( 'WordPress', 'firnera-lite' ) . '</a>'); ?>
			</p>

		</div>

	</div>

	<?php
}
//////////////////////////////////
// Adding Style
//////////////////////////////////
function firnera_lite_info_page_css( $hook ) {

	// Load styles and scripts only on theme info page.
	if ( 'appearance_page_firnera-lite' != $hook ) {
		return;
	}

	// Embed theme info css style.
	wp_enqueue_style( 'firnera_lite_info_page_css', get_template_directory_uri() .'/css/theme-info.css' );

}
add_action( 'admin_enqueue_scripts', 'firnera_lite_info_page_css' );