<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="initial-scale=1.0,width=device-width" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_head(); ?>
</head>
<body id="firnera-body"  <?php body_class('fffthemes');?>>
<?php wp_body_open(); ?>
	<header id="firnera-header">
		<div class="firnera-top-bar">
			<div class="fff-past">
				<div class="fff-row fff-flex">
					<div class="firnera-top-bar-mobile fff-1000 fff-flex justify-content-space-between">
				           
					<?php 

					if (has_nav_menu( 'firnera-top-menu' ) ) {

						echo ' <button class="firnera-top-menu-btn" type="button"><i class="fa fa-bars"></i></button>';
						wp_nav_menu(array(
							'theme_location' => 'firnera-top-menu',
							'container' => 'nav',
							'container_id' => 'firnera-top-menu',
							'menu_id' => 'firnera-top-menus',
							'menu_class' => 'fff-menu-list-reset fff-flex'
						)); 
						} 
						
						?><!-- Top Menu -->	
						<?php 

						$firnera_social_url_fb = get_theme_mod('firnera_lite_customizer_input_social_url_fb');
						$firnera_social_url_twitter = get_theme_mod('firnera_lite_customizer_input_social_url_twitter');
						$firnera_social_url_pinterest = get_theme_mod('firnera_lite_customizer_input_social_url_pinterest');
						$firnera_social_url_youtube = get_theme_mod('firnera_lite_customizer_input_social_url_youtube');
						$firnera_social_url_instagram = get_theme_mod('firnera_lite_customizer_input_social_url_instagram');
						$firnera_social_url_feed = get_theme_mod('firnera_lite_customizer_input_social_url_RSS');

						?>
						<div class="firnera-social-url fff-flex">
							<?php if ( $firnera_social_url_fb || $firnera_social_url_twitter || $firnera_social_url_pinterest || $firnera_social_url_youtube || $firnera_social_url_feed ) { ?>
							<ul class="fff-menu-list-reset fff-flex fff-align-content-center">
								<?php if ( !empty ($firnera_social_url_fb)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_fb); ?>" target="_blank"><i class="fa fa-facebook-square"></i></a></li>
								<?php  }
								if( !empty($firnera_social_url_twitter)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_twitter); ?>" target="_blank"><i class="fa fa-twitter fa-brands fa-x-twitter"></i></a></li>
								<?php  }
								if( !empty($firnera_social_url_pinterest)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_pinterest); ?>" target="_blank"><i class="fa fa-pinterest"></i></a></li>
								<?php  }
								if( !empty($firnera_social_url_youtube)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_youtube); ?>" target="_blank"><i class="fa fa-youtube"></i></a></li>
								<?php  }
								if( !empty($firnera_social_url_instagram)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_instagram); ?>" target="_blank"><i class="fa fab fa-brands fa-instagram"></i></i></a></li>
								<?php  }
								if( !empty($firnera_social_url_feed)) { ?>
								<li><a class="firnera-icon-scale" href="<?php echo esc_url($firnera_social_url_feed); ?>" target="_blank"><i class="fa fa-rss"></i></a></li>
								<?php } ?>
							</ul>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="firnera-header-main">
			<div class="fff-past">
				<div class="fff-row fff-flex firnera-header-left">
					<div class="firnera-logo-area">
						<div class="firnera-logo">
							<?php 
							if ( has_custom_logo() ) {  
								the_custom_logo(); 
							} else {
							?>
							<h1 class="firnera-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( bloginfo('name') ); ?></a></h1>
							<p class="firnera-site-des"><?php echo esc_html( bloginfo( 'description' ) ); ?></p>
							<?php

							}
							?>							
						</div>
					</div>
					<div class="firnera-header-ad-area">
						<div class="firnera-header-top-ads">
							<?php if ( is_active_sidebar( 'firnera-header-ad-widget' ) ) :
								dynamic_sidebar( 'firnera-header-ad-widget' );
							endif;  ?>
						</div><!-- Header Ad Widget -->
						<div class="firnera-header-top-ads-mobile">
							<?php if ( is_active_sidebar( 'firnera-header-ad-mobile-widget' ) ) :
								dynamic_sidebar( 'firnera-header-ad-mobile-widget' );
							endif;  ?>
						</div><!-- Header Ad Widget Mobile -->
					</div>
				</div>
			</div>
		</div>
	</header>
	<div id="firnera-main-menu-container" class="firnera-primary-menu fff-relative">
		<div class="fff-past">
			<div class="fff-row fff-flex">
				<div class="fff-1000">

				<div class="firnera-all-button-header fff-T-justify-content-space-between">
		            <button class="firnera-menu-btn" type="button" id="menu-btn">
						<i class="fa fa-bars"></i>
		            </button>
				<?php
						$firnera_search_class = '';
						$firnera_lite_header_search_enable = get_theme_mod('firnera_lite_customizer_header_search_enable', true);
						$firnera_search_class = ' firnera-search-btn-top-active';
						?><!-- Primary Menu -->
						<?php 
							if($firnera_lite_header_search_enable == true) {
						?>
					<button id="firnera-search-top-button"><i class="fa fa-search"></i></button>
				<?php }
				?>
				</div>
				<?php
				if (has_nav_menu( 'firnera-main-menu' ) ) {
						wp_nav_menu(array(
							'theme_location' => 'firnera-main-menu',
							'container' => 'nav',
							'container_class' => '',
							'container_id' => 'firnera-main-menu', 
							'menu_id' => 'firnera-main-menus',
							'menu_class' => 'fff-flex' . $firnera_search_class
						)); 
					} 
						?>
				</div>
			</div>
		</div>
	</div>

<!-- Search Form -->
<?php 
	if($firnera_lite_header_search_enable == true) {
?>
<div class="fff-full">
	<div class="fff-row">
		<div class="fff-1000">
			<div id="firnera-top-search" class="firnera-form-animate-search">
				<span class="firnera-top-close"></span>
				<form role="firnera-top-search" id="firnera-searchform-top" action="<?php echo esc_url(home_url( '/' )); ?>">
                    <?php if (function_exists('WC') && (is_post_type_archive('product') || is_tax('product-category'))) { ?>
					<input type="hidden" name="post_type" value="product">
                    <?php } else { ?>
					<input type="hidden" name="post_type" value="post">
                    <?php } ?>
					<input value="<?php the_search_query(); ?>" name="s" type="search" placeholder="<?php echo esc_attr__( 'Type to search then Enter', 'firnera-lite' ); ?>"/>
				</form>
			</div>
		</div>
	</div>
</div>
<?php } ?>
<div class="firnera-after-menu-ad-container">
<?php 
if ( is_active_sidebar( 'firnera-custom-sidebar-after-menu' ) ) :
	dynamic_sidebar( 'firnera-custom-sidebar-after-menu' );
endif; 
 ?>
</div>	