<?php




//////////////////////////////////
//////						//////
//////    Theme Options		//////
//////					    //////
//////////////////////////////////
include(get_template_directory() . '/inc/theme-options.php');



//////////////////////////////////
//////						//////
//////    Theme Info 		//////
//////					    //////
//////////////////////////////////


include(get_template_directory() . '/inc/theme-info.php');


if ( ! function_exists( 'firnera_lite_setup' ) ) :

function firnera_lite_setup() {


///////////////////////
// TITLE TAG SUPPORT
///////////////////////
add_theme_support( 'title-tag' );

///////////////////////
// Localization Support
///////////////////////
load_theme_textdomain( 'firnera-lite', get_template_directory().'/languages' );
$locale = get_locale();
$locale_file = get_template_directory().'/languages/$locale.php';
if ( is_readable($locale_file) ) {
    require_once($locale_file);
}


///////////////////////
/// Content Width
///////////////////////
if ( ! isset( $content_width ) ) {
	$content_width = 690;
}

///////////////////////
/// Add Menu Support
///////////////////////

register_nav_menu('firnera-top-menu', __('Top Menu ( Note: do not make a child menu, because the child menu will not be displayed in the Top menu )','firnera-lite'));
register_nav_menu('firnera-main-menu', __('Main Navigation Menu','firnera-lite'));


///////////////////////
/// Background Support
///////////////////////
$firnera_lite_background = array(
	'default-color' => 'ffffff'
);
add_theme_support( 'custom-background', $firnera_lite_background );

// Indicate widget sidebars can use selective refresh in the Customizer.
add_theme_support( 'customize-selective-refresh-widgets' );

///////////////////////
/// Misc
///////////////////////
add_theme_support('automatic-feed-links' );


define('firnera_lite_theme_url','https://firdaus.asia');

	//////////////////////////
	/// Custom Logo
	/////////////////////////

    $firnera_lite_custom_logo = array(
        'height'      => 100,
        'width'       => 300,
        'flex-width'  => true,
    );
    add_theme_support( 'custom-logo', $firnera_lite_custom_logo );




///////////////////////
/// Featured Image
///////////////////////
add_theme_support( 'post-thumbnails');
set_post_thumbnail_size( 500, 500, true );
add_image_size( 'firnera-left-thumb',500 ,500, array('center','center') );



///////////////////////
// Add Woocommerce Support 
///////////////////////

add_theme_support( 'woocommerce' );

add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );

}
endif; 
add_action( 'after_setup_theme', 'firnera_lite_setup' );


///////////////////////
// Add Sidebar
///////////////////////
function firnera_lite_add_sidebar_widgets() {
	register_sidebar(array(
		'name'=> esc_html__('Header Ad Widget','firnera-lite'),
		'id' => 'firnera-header-ad-widget',
		'before_widget' => '<div id="%1$s" class="firnera-widget-ad widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="firnera-header-ad-widget-title">',
		'after_title' => '</h2>',
		'description' => esc_html__('NOTE: Header Ad Widget Only Show in Dekstop.','firnera-lite')
	));
	register_sidebar(array(
		'name'=> esc_html__('Header Ad Mobile Widget','firnera-lite'),
		'id' => 'firnera-header-ad-mobile-widget',
		'before_widget' => '<div id="%1$s" class="firnera-widget-ad widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="firnera-header-ad-widget-title">',
		'after_title' => '</h2>',
		'description' => esc_html__('NOTE: Header Ad Widget Only Show in Mobile.','firnera-lite')
	));
	register_sidebar(array(
		'name'=> esc_html__('Sidebar One','firnera-lite'),
		'id' => 'firnera-sidebar-one',
		'before_widget' => '<div id="%1$s" class="firnera-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="firnera-header-widget-title"><h2 class="widgettitle">',
		'after_title' => '</h2><span class="firnera-lite-dem"></span></div>',
		'description' => esc_html__('NOTE: Recommended width is 300px.','firnera-lite')
	));
	register_sidebar(array(
		'name'=> esc_html__('Sidebar Two','firnera-lite'),
		'id' => 'firnera-sidebar-two',
		'before_widget' => '<div id="%1$s" class="firnera-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="firnera-header-widget-title"><h2 class="widgettitle">',
		'after_title' => '</h2><span class="firnera-lite-dem"></span></div>',
		'description' => esc_html__('NOTE: Recommended width is 300px.','firnera-lite')
	));	
	register_sidebar( array(
		'name' => esc_html__('Firnera Woocommerce Sidebar One','firnera-lite'),
		'id' => 'firnera-lite-woocommerce-widgets',
		'description' => esc_html__('Note: Woocommerce Sidebar One','firnera-lite'),
		'before_widget' => '<div id="%1$s" class="firnera-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="firnera-header-widget-title"><h2 class="widgettitle">',
		'after_title' => '</h2><span class="firnera-lite-dem"></span></div>',
	) );
	
	register_sidebar( array(
		'name' => esc_html__('Firnera Woocommerce Sidebar Two','firnera-lite'),
		'id' => 'firnera-lite-woocommerce-widgets-two',
		'description' => esc_html__('Note: Woocommerce Sidebar Two','firnera-lite'),
		'before_widget' => '<div id="%1$s" class="firnera-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="firnera-header-widget-title"><h2 class="widgettitle">',
		'after_title' => '</h2><span class="firnera-lite-dem"></span></div>',
	) );	
	register_sidebar(array(
		'name' => esc_html__('Sidebar Widgets Ad After Menu','firnera-lite'),
		'id' => 'firnera-custom-sidebar-after-menu',
		'description' => esc_html__('Note: This Advertisement. Important: Use Text widgets to insert code','firnera-lite'),
		'before_widget' => '<div id="%1$s" class="firnera-ad-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));
	register_sidebar(array(
		'name' => esc_html__('Sidebar Widgets Ad Before Footer','firnera-lite'),
		'id' => 'firnera-custom-sidebar-before-footer',
		'description' => esc_html__('Note: This Advertisement. Important: Use Text widgets to insert code','firnera-lite'),
		'before_widget' => '<div id="%1$s" class="firnera-ad-widget widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));

}
add_action( 'widgets_init', 'firnera_lite_add_sidebar_widgets' );

function firnera_lite_post_meta( $fff_comments = false ){
	?>
		<ul class="firnera-post-meta">
			<li><i class="fa fa-clock-o"></i><?php echo get_the_date();?></li>
			<li><i class="fa fa-user"></i><?php the_author_posts_link();?></li>
			<li><i class="fa fa-folder-open"></i><?php the_category(', '); ?></li>
			<?php if( $fff_comments == true) { ?>
			<li><i class="fa fa-comments"></i><?php comments_popup_link(__('No Comments','firnera-lite'), __('1 Comment','firnera-lite'), __('% Comments','firnera-lite'), 'firnera-commentsLink');?></li>
			<?php } ?>
		</ul><!--end metaPosts-->
	<?php
}

///////////////////////
/// Excerpt
///////////////////////

function firnera_custom_excerpt_length( $length ) {
    return 16;
}
add_filter( 'excerpt_length', 'firnera_custom_excerpt_length', 999 );

function firnera_excerpt_more( $more ) {
    return '...';
}
add_filter( 'excerpt_more', 'firnera_excerpt_more' );





///////////////////////
/// Pagination
///////////////////////

function firnera_lite_numeric_pagination(){
	echo '<div id="firnera-lite-navigation">';
	the_posts_pagination( array(
		'mid_size' => 2,
		'prev_text' => __( 'Prev', 'firnera-lite' ),
		'next_text' => __( 'Next', 'firnera-lite' ),
	));
	echo '</div>';
}





/////////////////////////////////////
//// Add Google Font
/////////////////////////////////////


function firnera_google_fonts_url_Playfair_and_Source() {
	$fonts_url = '';
	 

	$Heading = _x( 'on', 'Playfair Display font: on or off', 'firnera-lite' );
	 
	$Body = _x( 'on', 'Source Sans Pro: on or off', 'firnera-lite' );
	 
	if ( 'off' !== $Heading || 'off' !== $Body) {
	$font_families = array();
	 
	if ( 'off' !== $Heading ) {
	$font_families[] = 'Playfair Display:400,400i,500,500i,600,600i,700,700i,800,800i';
	}
	 
	if ( 'off' !== $Body ) {
	$font_families[] = 'Source Sans Pro:400,400i,500,500i,600,600i,700,700i';
	}
	 
	$query_args = array(
	'family' => urlencode( implode( '|', $font_families ) ),
	'subset' => urlencode( 'latin,latin-ext' ),
	);
	$protocol = is_ssl() ? 'https' : 'http';
	$fonts_url = add_query_arg( $query_args, "$protocol://fonts.googleapis.com/css" );
	}
 
return esc_url_raw( $fonts_url );
}


function firnera_lite_scripts() {
	wp_enqueue_style('firnera-google-fonts', firnera_google_fonts_url_Playfair_and_Source(), array(), null );
	wp_enqueue_style('firnera-lite-normalize', get_template_directory_uri() . '/css/normalize.css');
	wp_enqueue_style('firnera-lite-fffthemes', get_template_directory_uri() . '/css/fffthemes.css');
	wp_enqueue_style('firnera-lite-style', get_stylesheet_uri() );
	wp_enqueue_style('firnera-lite-fffthemesresponsive', get_template_directory_uri() . '/css/fffthemes-responsive.css');
	wp_enqueue_style('firnera-lite-responsive', get_template_directory_uri() . '/css/responsive.css');

	wp_enqueue_script('jquery');
	wp_enqueue_script('firnera-lite-jquery-sticky', get_template_directory_uri() . '/js/jquery.sticky.js', 'jquery', '1.0.4', true);
	wp_enqueue_script('firnera-lite-ace-responsive-menu-min', get_template_directory_uri() . '/js/ace-responsive-menu-min.js', 'jquery', '1.0.0', true);
	wp_enqueue_script('firnera-lite-custom', get_template_directory_uri() . '/js/firnera-lite-custom.js', 'jquery', '1.0.0', true);
	

	 
	if ( is_singular() ) { 
		wp_enqueue_script( "comment-reply" );
	}
	
}
add_action( 'wp_enqueue_scripts', 'firnera_lite_scripts' );




if ( function_exists('WC')){

	add_filter( 'woocommerce_breadcrumb_defaults', 'firnera_lite_custom_woocommerce_breadcrumbs' );
	function firnera_lite_custom_woocommerce_breadcrumbs() {
		return array(
				'delimiter'   => '<li class="fir-demiliter-bc"><i class="fa fa-angle-right"></i></li>',
				'wrap_before' => '<nav id="fir-crumbs" itemprop="breadcrumb"><ul>',
				'wrap_after'  => '</ul></nav>',
				'before' => '<li>',
				'after' => '</li>',
				'home' => _x( '<i class="fa fa-home"></i>Home', 'breadcrumb', 'firnera-lite' ),
			);
	}
}