<?php

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

add_action('wp', "firmasite_promotionbar_init" );
function firmasite_promotionbar_init() {
	global $firmasite_settings;
	if (isset($firmasite_settings["promotionbar-where"]) && 'remove' == $firmasite_settings["promotionbar-where"]) {
		/* maybe we need this section */
		do_action("firmasite_promotionbar_removed");
	} else { 
		global $firmasite_promotionbar,$firmasite_settings;
		$firmasite_promotionbar_posts = new WP_Query( array( 
			'post_type' => apply_filters( 'firmasite_pre_get_posts_ekle', array( 'post', 'page' )), 
			'posts_per_page' => apply_filters( 'firmasite_promotionbar_count', 9),
			'ignore_sticky_posts' => 1,
			'meta_query' => array(
				array(
					'key' => '_firmasite_promotionbar',
					'value' => true,				
				)		
			),
		));
		$firmasite_promotionbar_media = new WP_Query( array( 
			'post_type' => 'attachment', 
			'posts_per_page' => apply_filters( 'firmasite_promotionbar_count', 9),
			'ignore_sticky_posts' => 1,
			'post_status' => 'inherit',
			'meta_query' => array(
				array(
					'key' => '_firmasite_promotionbar',
					'value' => true,				
				)		
			),
		));
		if ( $firmasite_promotionbar_media->have_posts() ) {
			$mergedposts = array_merge( $firmasite_promotionbar_posts->posts, $firmasite_promotionbar_media->posts );
			$postids = array();
			foreach( $mergedposts as $item ) {
				$postids[]=$item->ID; //create a new query only of the post ids
			}
			$uniqueposts = array_unique($postids); //remove duplicate post ids
		
			$firmasite_promotionbar = new WP_Query( array( 
				'post__in' => $uniqueposts, 
				'post_type' => 'any', 
				'posts_per_page' => apply_filters( 'firmasite_promotionbar_count', 9),
				'post_status' => 'any',
				'ignore_sticky_posts' => 1
			));
		} else {
			$firmasite_promotionbar = $firmasite_promotionbar_posts;
		}
		
		if ( $firmasite_promotionbar->have_posts() ) {
			
			switch($firmasite_settings["promotionbar-location"]) {
				case 'open_footer':
					add_action( 'open_footer', "firmasite_promotionbar_where");
					break;
				case 'open_sidebar':
					add_action( 'open_sidebar', "firmasite_promotionbar_where");					
					break;
				case 'close_sidebar':
					add_action( 'close_sidebar', "firmasite_promotionbar_where");
					break;
				case 'before_content':
					add_action( 'before_content', "firmasite_promotionbar_where");
					break;
			}
		
			function firmasite_promotionbar_where(){
				global $firmasite_promotionbar,$firmasite_settings;
				switch($firmasite_settings["promotionbar-where"]) {
					case 'home-only':
						if(is_front_page())
							firmasite_promotionbar_content();
						 break;
					case 'remove':
						 break;
					case 'everywhere':
							firmasite_promotionbar_content();
						 break;
				}
			}
			function firmasite_promotionbar_content(){
				global $firmasite_promotionbar,$firmasite_settings,$post;
				?>  
					<div class="hidden-xs carousel vertical slide carousel-mini <?php echo $firmasite_settings["promotionbar-location"]; ?>" id="firmasite-promotionbar" data-rel="carousel">
						<?php if(isset($firmasite_settings["promotionbar-title"])){ ?>
						<h4>
							<?php echo $firmasite_settings["promotionbar-title"]; ?>  
						</h4>
						<?php } ?>
						<div class="carousel-inner">
						<?php
							switch ($firmasite_settings["promotionbar-location"]) {
								case "close_sidebar":
								case "open_sidebar":
								   $slide_item_count = 1;
								  break;
								default:
								case "before_content":
								case "after_content":
									$slide_item_count = apply_filters("firmasite_promotionbar_row_count", 3);
								  break;
							}			
							$slide_num = 0;
							$slide_new = true;
							$slide_change = false;
							$slide_active = true;
							$slide_id = $firmasite_promotionbar->post_count;
							$total_slide = floor(($firmasite_promotionbar->post_count-1) / $slide_item_count); // starting from 0
							$slide_finished = $firmasite_promotionbar->post_count;
							while ( $firmasite_promotionbar->have_posts() ) {
								$firmasite_promotionbar->the_post();
									global $post,$more;
									$more = 0;
								
									$slide_num++;
									if ($slide_num == $slide_item_count) {
										$slide_change = true;
									}
									if($slide_new) {		
									?>
									  <div class="item <?php if ($slide_active) echo "active"; $slide_active = false; ?>">
										<div class="row">
									 <?php $slide_new = false;
									  } ?>       
											<div class="col-xs-12 col-md-<?php echo 12/$slide_item_count;?>">
												<?php get_template_part( 'templates/promotionbar', $post->post_type ); ?>                                    
											</div>
								<?php 
									$slide_finished--;
									if($slide_change || 0 == $slide_finished) { ?>	                
										</div>
									  </div>
								<?php	$slide_change = false;
										$slide_new = true;
										$slide_num = 0;
									} ?>
						<?php
							}
							?>
						</div>
							<?php if ($total_slide > 0) { ?>
								<a data-slide="prev" href="#firmasite-promotionbar" class="left carousel-control"><span class="icon-prev"></span></a>
								<a data-slide="next" href="#firmasite-promotionbar" class="right carousel-control"><span class="icon-next"></span></a>
							<?php } ?>
					</div>
				<?php
				/* Restore original Post Data */
				wp_reset_postdata();			
			}
		} 
		
		
		// add fetured colum to posts
		function firmasite_add_js_promotionbar_colum( $columns ){
			$columns['promotionbar_js_posts'] = __( 'Add to PromotionBar', 'firmasite' ); return $columns;
		} add_filter('manage_posts_columns', 'firmasite_add_js_promotionbar_colum', 99);
		add_filter('manage_pages_columns', 'firmasite_add_js_promotionbar_colum', 99);
		add_filter('manage_media_columns', 'firmasite_add_js_promotionbar_colum', 99);
		
		// add the content to our new colum
		function firmasite_add_js_promotionbar_post_column_content( $col, $id ){
			
			if ( $col == 'promotionbar_js_posts' ){
				$class = '';
				$firmasite_promotionbar = get_post_meta( $id, '_firmasite_promotionbar', true );
				if ( !empty( $firmasite_promotionbar ) ){ $class = ' selected'; }
				$js_nonce = wp_create_nonce( 'jspromotionbar_'.$id );
				echo  '<a data-nonce="'.$js_nonce.'" data-id="'.$id.'" id="postpromotionbar_'.$id.'" class="promotionbar_posts_star'.$class.'" title="'. __( 'Add to PromotionBar', 'firmasite' ). '"></a>';            
			}
			
		} add_action('manage_posts_custom_column', 'firmasite_add_js_promotionbar_post_column_content', 10, 2);
		add_action('manage_pages_custom_column', 'firmasite_add_js_promotionbar_post_column_content', 10, 2);
		add_action('manage_media_custom_column', 'firmasite_add_js_promotionbar_post_column_content', 10, 2);
		
		// get of this this themes cpts and loop through them to create the correct action and filters
		add_action('admin_init','firmasite_js_promotionbar_posts_get_and_loop_through_post_types');
		function firmasite_js_promotionbar_posts_get_and_loop_through_post_types(){
			
			$firmasite_promotionbar_post_types = apply_filters( 'firmasite_pre_get_posts_ekle', array());
			foreach ($firmasite_promotionbar_post_types as $post_type ) {            
				add_filter('manage_edit-'.$post_type.'_columns', 'firmasite_add_js_promotionbar_colum', 99);
				// it shows double time if we dont remove this
				//add_action('manage_'.$post_type.'_posts_custom_column', 'firmasite_add_js_promotionbar_post_column_content', 10, 2);            
			}
			
		} 
		
		// change the width of our colum
		function firmasite_js_promotionbar_posts_colum_width(){
		 ?>
			<style>
				#promotionbar_js_posts, .column-promotionbar_js_posts{ width:100px; text-align: center !important; }
				.promotionbar_posts_star{ display:block; height:24px; width:24px; margin:8px auto 0 auto; border:none; 
					background: transparent url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAwCAMAAAA8VkqRAAAAA3NCSVQICAjb4U/gAAABXFBMVEX/////sxP/myT/fCv/rxT/qxn/piD/fCv/sxP/qxn/pRr/fCv/dij/qx//qxn/pRr/fCv/fh//nhn/fCv/cyD/vRT/tB//piD/myT/cyD/pRr/fCv/dij/vRT/qxn/pRr/fCv/cyD/sxP/pRr/fCv/cyD/rxT/pRr/fCv/pRr/iCL/fCv/cyD/qx//piD/pRr/myT/fCv/tB//fCv/aCL////39/fv7+/m5ub/5Une3t7/30vW1tb/1kv/zlD/zkrMzMz/xUz/w0PFxcX/vkz/u2P/vVL/wCT/vT3/vEH/tGP/uTq9vb3/tkL/s1H/tB//rmL/rVz/rVH/sxP/sDK1tbX/rCj/rxT/plT/qx//qxn/pFz/pT7/piD/pRr/n1mtra3/nFX/nE7/nhn/myT/lU+kpKT/lEH/jzP/kSH/jjeenp7/iz//hzD/fCv/fS7/fh//cyD/bSj/aCJTTgtJAAAAdHRSTlMAERERIiIiIjMzMzMzRERERERVVVVmZmZmd4iIiJmZmZmZqqqqqru7u8zMzMzd3d3d3e7u7v///////////////////////////////////////////////////////////////////////////////////yAMqI8AAAAJcEhZcwAACxIAAAsSAdLdfvwAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzVxteM2AAABz0lEQVQ4jZWR61fTMByGI8hFvM0LioJOboJyEcVcCGmXkYE6qqDYsXEpLZubNwqD//8c0vYsyWH5wvth7Z6nb5NfCoDK8IsbwJbBnZ0Jq3j9aWX3poXf2ltd3XppEZNbjuPs9XXxoUByp5a/gvvuz9QKMk5wT3WGnk++CYJ6xS0UiwW3Ug+CdzP5h1J8qFc2XdctZpF37uefjeAJAAu1YilBpTTZ3VrtLgD9i4elK/ly+DRZpH+xsfHNzNeMA9Cz9MfkB42RzsZ63v7+oXM2osd40Nb8ZNqY71m7qtKaN8T4qRbVtiHm/0dRVF1f/55c2ne0+PgrOir/jZfj8n4UXTxWfOD8aLsVz97uHV0+Le+fjymRi4/juVz6yKv4pDWlRO/s3CPVnnqf6/pY1w7lyMoxxdwqOIQUWwsQIluFIwgh664kBUsFYZYUICRE7QwzxijBGZcdQinjFALgkw7TwZwBEHYLhIVcy/MIQoaTfzAP5e6Q55sm4yTdUWZUOlwaYRrMOlwanxrCJ3o+YQrPGNwzFxHQEDh7OP3l+iChh2WIPInkypg+WS4xD32vKaSiehEqJA45RsyXioVKkH/NUKRvTlRTNyAXeiYmbB/eyCVEzJn10KjKYAAAAABJRU5ErkJggg==) 0 -24px no-repeat; cursor:pointer; }
				.promotionbar_posts_star.selected, .promotionbar_posts_star:active{ background-position:0 0; }
			</style>
			<?php
		
		} add_action('admin_head','firmasite_js_promotionbar_posts_colum_width');
		
		// add jquery function to admin head to save
		function firmasite_js_promotionbar_posts_add_jquery_to_head(){
			
			if ( current_user_can("manage_options") ){ ?>					
				
				<script type="text/javascript" language="javascript">                
					jQuery(document).ready(function(){                
						// when the checkbox is clicked save the meta option for this post
		
						jQuery('.promotionbar_posts_star').click(function() {
							var selected = 'yes';
							if ( jQuery(this).hasClass( 'selected' ) ){ 
								jQuery(this).removeClass( 'selected' );
								selected = 'no'; 
							} else { jQuery(this).addClass( 'selected' ); }                        
							// get id
							var postID = jQuery(this).attr('data-id');
							var jspromotionbarnonce = jQuery(this).attr('data-nonce');          
							jQuery.post( ajaxurl, 'action=jspromotionbar_posts&post='+postID+'&jspromotionbar-nonce='+jspromotionbarnonce+'&firmasite_promotionbar='+selected ); 
								
						}); 
							
					}); 
				
				</script> <?php
		
			}
		
		} add_action( 'admin_head', 'firmasite_js_promotionbar_posts_add_jquery_to_head' );
		

	}
} // firmasite_promotionbar_init



// add ajax call to wp in order to save the remove delete post link
add_action('wp_ajax_jspromotionbar_posts', 'firmasite_js_promotionbar_posts_link_add_ajax_call_to_wp');
function firmasite_js_promotionbar_posts_link_add_ajax_call_to_wp(){	
	
	check_ajax_referer('jspromotionbar_'.(int)$_POST["post"], 'jspromotionbar-nonce');
		
	$firmasite_promotionbar = $_POST['firmasite_promotionbar'];
	$currentJSPostID = (int)$_POST["post"];
	
	if( !empty( $currentJSPostID ) && $firmasite_promotionbar !== NULL ) {
		if ( $firmasite_promotionbar == 'no' ){ 
			delete_post_meta( $currentJSPostID, "_firmasite_promotionbar" ); 
		} else { 
			add_post_meta( $currentJSPostID, "_firmasite_promotionbar", true ); 
		}
	} 

	exit;
} 
		

		
add_action( 'customize_register', "firmasite_promotionbar_register");
function firmasite_promotionbar_register($wp_customize) {
	 global $firmasite_settings_desc, $firmasite_settings;
	
	// Promotion Bar
	$wp_customize->add_section( 'promotionbar-settings', array(
			'title' => __( 'Promotion Bar', 'firmasite' ), // The title of section
			//'description' => __( 'These settings will activate when you save changes and refresh this page.', 'firmasite' ), // The description of section
			'priority' => '99',
	) );

		// promotionbar-calltoaction
		$wp_customize->add_setting( 'firmasite_settings[promotionbar-title]', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_attr'
		) );
		$wp_customize->add_control( 'firmasite_settings[promotionbar-title]', array(
			'label'    => __( 'Title', 'firmasite' ),
			'type' => 'text',
			'section'  => 'promotionbar-settings',
			//'priority' => '99',
		) );			
			// Adding explanation for setting
			$firmasite_settings_desc["promotionbar-title"]['content'] = esc_attr__( "If you leave it empty, it wont show title. Example titles: <b>Editor's Choice</b>, <b>Must Read List</b> ", 'firmasite' ); 


		// promotionbar-where
		$wp_customize->add_setting( 'firmasite_settings[promotionbar-where]', array(
			'default' => 'everywhere',
			'type' => 'option',
			'sanitize_callback' => 'esc_attr'
		) );			 
		$wp_customize->add_control( 'firmasite_settings[promotionbar-where]', array(
			'label' => __( 'Where do you want to show Promotion Bar?', 'firmasite' ),
			'section' => 'promotionbar-settings',
			'type' => 'radio',
			'priority' => '20',
			'choices' => array(
				"home-only" => __( 'Only Home Page', 'firmasite' ),	//0
				"everywhere" => __( 'All Site', 'firmasite' ),	//1
				"remove" => __( 'Remove Promotion Bar', 'firmasite' ),	//1
			),
		) );						

		// promotionbar-location
		$wp_customize->add_setting( 'firmasite_settings[promotionbar-location]', array(
			'default' => 'open_sidebar',
			'type' => 'option',
			'sanitize_callback' => 'esc_attr'
		) );			 
		$wp_customize->add_control( 'firmasite_settings[promotionbar-location]', array(
			'label' => __( 'Which location do you want to show Promotion Bar?', 'firmasite' ),
			'section' => 'promotionbar-settings',
			'type' => 'radio',
			'priority' => '20',
			'choices' => array(
				"before_content" => __( 'Before Content', 'firmasite' ),	
				"open_footer" => __( 'In Site Footer', 'firmasite' ),	
				"open_sidebar" => __( 'In top of Sidebar', 'firmasite' ),	
				"close_sidebar" => __( 'In bottom of Sidebar', 'firmasite' ),	
			),
		) );						
		
}




