<?php
/**
 * financeup functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package financeup
 */


	$financeup_theme_path = get_template_directory() . '/inc/ansar/';

	require( $financeup_theme_path . '/financeup-custom-navwalker.php' );
	require( $financeup_theme_path . '/widget/financeup-service.php');
	require( $financeup_theme_path . '/font/font.php');

	/*-----------------------------------------------------------------------------------*/
	/*	Enqueue scripts and styles.
	/*-----------------------------------------------------------------------------------*/
	require( $financeup_theme_path .'/enqueue.php');
	/* ----------------------------------------------------------------------------------- */
	/* Customizer */
	/* ----------------------------------------------------------------------------------- */
	
	require( $financeup_theme_path . '/customize/ta_customize_top_header.php');
	require( $financeup_theme_path . '/customize/ta_customize_homepage.php');
	require( $financeup_theme_path . '/customize/ta_customize_copyright.php');
	require( $financeup_theme_path . '/customize/ta_customize_general.php');
	require( $financeup_theme_path . '/customize/class-alpha-color-control/class-alpha-color-control.php');
	require_once( trailingslashit( get_template_directory() ) . 'inc/ansar/customize/customize-pro/class-customize.php' );

// Theme version.
$financeup_theme = wp_get_theme();
define( 'FINANCEUP_THEME_VERSION', $financeup_theme->get( 'Version' ) );
define ( 'FINANCEUP_THEME_NAME', $financeup_theme->get( 'Name' ) );
	
if ( ! function_exists( 'financeup_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function financeup_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on financeup, use a find and replace
	 * to change 'financeup' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'financeup', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	//Added selecctive refresh for widget
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __('Primary menu','financeup' ),
        'footer' => __('Footer Menu','financeup' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	
	/* Add theme support for responsive embeds */
	add_theme_support( 'responsive-embeds' );
		
	//Custom logo
	add_theme_support( 'custom-logo');

	//Block Style
	add_theme_support( 'wp-block-styles');

	/* Add theme support for gutenberg block */
	add_theme_support( 'align-wide' );

	// custom header Support
	$args = array(
		'default-image'		=> '',
		'width'			=> '1600',
		'height'		=> '600',
	);
	add_theme_support( 'custom-header', $args );

	$args = array(
		'default-color' => '#fff',
		'default-image' => '',
	);
	add_theme_support( 'custom-background', $args );

	function financeup_the_custom_logo() {
	
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}

	}

	add_filter('get_custom_logo','financeup_logo_class');


	function financeup_logo_class($html)
	{
	$html = str_replace('custom-logo-link', 'navbar-brand', $html);
	return $html;
	}

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
	) );


    // Set up the woocommerce feature.
    add_theme_support( 'woocommerce');

}
endif;
add_action( 'after_setup_theme', 'financeup_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function financeup_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'financeup_content_width', 640 );
}
add_action( 'after_setup_theme', 'financeup_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function financeup_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'financeup' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="ta-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h6>',
		'after_title'   => '</h6>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area', 'financeup' ),
		'id'            => 'footer_widget_area',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="col-md-3 col-sm-6 rotateInDownLeft animated ta-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h6>',
		'after_title'   => '</h6>',
	) );
}
add_action( 'widgets_init', 'financeup_widgets_init' );


add_action('widgets_init', 'financeup_register_widgets');

function financeup_register_widgets() {    

    register_widget('financeup_service_widget');
	
	
	$financeup_sidebars = array (  'sidebar-service' => 'sidebar-service');
	
	/* Register sidebars */
	foreach ( $financeup_sidebars as $financeup_sidebar ):
	
		if( $financeup_sidebar == 'sidebar-service' ):
		
			$financeup_name = __('Service section widgets', 'financeup');
			
		else:

			$financeup_name = $financeup_sidebar;
			
		endif;
		
        register_sidebar(
            array (
                'name'          => $financeup_name,
                'id'            => $financeup_sidebar,
                'before_widget' => '<div id="%1$s" class="ta-widget %2$s">',
                'after_widget'  => '</div>'
            )
        );
		
    endforeach;
	
}

function financeup_enqueue_customizer_controls_styles() {
  wp_register_style( 'financeup-customizer-controls', get_template_directory_uri() . '/css/customizer-controls.css', NULL, NULL, 'all' );
  wp_enqueue_style( 'financeup-customizer-controls' );
  }
add_action( 'customize_controls_print_styles', 'financeup_enqueue_customizer_controls_styles' );


/* Custom template tags for this theme. */
require get_template_directory() . '/inc/ansar/template-tags.php';

/*Load Jetpack compatibility file. */
require get_template_directory() . '/inc/jetpack.php';

//Read more Button on slider & Post
function financeup_read_more() {
	
	global $post;
	
	$readbtnurl = '<a class="btn btn-tislider-two" href="' . get_permalink() . '">'.__('Read More','financeup').'</a>';
	
    return $readbtnurl;
}
add_filter( 'the_content_more_link', 'financeup_read_more' );

if ( ! function_exists( 'wp_body_open' ) ) :
	/**
	 * Fire the wp_body_open action.
	 *
	 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
	 *
	 * @since Twenty Nineteen 1.4
	 */
	function wp_body_open() {
		/**
		 * Triggered after the opening <body> tag.
		 *
		 * @since Twenty Nineteen 1.4
		 */
		do_action( 'wp_body_open' );
	}
endif;