<?php
/**
 * Title: Banner
 * Slug: fashion-vista/banner
 * Categories: fashion-vista
 *
 * @package Fashion Vista
 * @since 1.0.0
 */

?>
<!-- wp:group {"metadata":{"name":"Banner"},"style":{"spacing":{"padding":{"top":"80px","bottom":"80px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:80px;padding-bottom:80px"><!-- wp:columns {"style":{"spacing":{"padding":{"right":"0","left":"0"},"blockGap":{"top":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns" style="padding-right:0;padding-left:0"><!-- wp:column {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
<div class="wp-block-column" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img1.jpg","id":2019,"dimRatio":0,"customOverlayColor":"#63544d","isUserOverlayColor":true,"minHeight":520,"style":{"border":{"radius":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-radius:2px;min-height:520px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#63544d"></span><img class="wp-block-cover__image-background wp-image-2019" alt="woman-sunglasses" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img1.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"30%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:30%"><!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"}}} -->
<h1 class="wp-block-heading has-text-align-center" style="font-style:normal;font-weight:400;line-height:1"><?php echo esc_html__( 'THE WINTER', 'fashion-vista' ); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"0.8","fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"xx-large","fontFamily":"allura"} -->
<p class="has-text-align-center has-allura-font-family has-xx-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:500;line-height:0.8"><?php echo esc_html__( 'wishlist', 'fashion-vista' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|60"}},"typography":{"lineHeight":"1.4"},"elements":{"link":{"color":{"text":"var:preset|color|black"}}}},"textColor":"black","fontSize":"small","fontFamily":"jost"} -->
<p class="has-text-align-center has-black-color has-text-color has-link-color has-jost-font-family has-small-font-size" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--60);line-height:1.4"><?php echo esc_html__( 'From warm knits and luxurious outerwear to festive home decor and thoughtful gifts, our curated collection for everyone', 'fashion-vista' ); ?>.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"radius":"2px"}},"fontFamily":"jost"} -->
<div class="wp-block-button has-jost-font-family"><a class="wp-block-button__link wp-element-button" style="border-radius:2px"><?php echo esc_html__( 'NEW ARRIVALS', 'fashion-vista' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
<div class="wp-block-column"><!-- wp:columns {"isStackedOnMobile":false,"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|20"}}}} -->
<div class="wp-block-columns is-not-stacked-on-mobile"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img2.jpg","id":3751,"dimRatio":0,"customOverlayColor":"#a6afc3","isUserOverlayColor":true,"focalPoint":{"x":0.44,"y":0.03},"minHeight":258,"isDark":false,"style":{"border":{"radius":"2px"}}} -->
<div class="wp-block-cover is-light" style="border-radius:2px;min-height:258px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#a6afc3"></span><img class="wp-block-cover__image-background wp-image-3751" alt="woman-bags" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img2.jpg" style="object-position:44% 3%" data-object-fit="cover" data-object-position="44% 3%"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img3.jpg","id":3709,"dimRatio":0,"customOverlayColor":"#4f4537","isUserOverlayColor":true,"focalPoint":{"x":0.28,"y":0.13},"minHeight":258,"style":{"border":{"radius":"2px"}}} -->
<div class="wp-block-cover" style="border-radius:2px;min-height:258px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#4f4537"></span><img class="wp-block-cover__image-background wp-image-3709" alt="woman-hat-forest" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img3.jpg" style="object-position:28% 13%" data-object-fit="cover" data-object-position="28% 13%"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|20"}}}} -->
<div class="wp-block-columns is-not-stacked-on-mobile"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img4.jpg","id":4351,"dimRatio":0,"minHeight":258,"isDark":false,"style":{"border":{"radius":"2px"}}} -->
<div class="wp-block-cover is-light" style="border-radius:2px;min-height:258px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-4351" alt="woman-sky-hair-tops" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img4.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img5.jpg","id":4352,"dimRatio":0,"minHeight":258,"isDark":false,"style":{"border":{"radius":"2px"}}} -->
<div class="wp-block-cover is-light" style="border-radius:2px;min-height:258px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-4352" alt="woman-hat" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/img5.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->