<?php

class Whizzie {

	public function __construct() {
		$this->init();
	}

	public function init()
	{
	
	}

	public static function fashion_shop_storefront_setup_widgets(){

	set_theme_mod( 'fashion_shop_storefront_header_toptxt', 'Summer Sale For All Products and Free Delivery - OFF 50% Shop Now' );
	set_theme_mod( 'fashion_shop_storefront_header_wishlist_url', '#' );
	set_theme_mod( 'fashion_shop_storefront_header_phone_number', '+123 456 789' );
	set_theme_mod( 'fashion_shop_storefront_header_phone_number_text', 'Call Us' );
	set_theme_mod('fashion_shop_storefront_social_links_settings', array(
		array(
			"link_text" => "fab fa-instagram",
			"link_url" => "www.instagram.com"
		),
		array(
			"link_text" => "fab fa-twitter",
			"link_url" => "www.twitter.com"
		),
		array(
			"link_text" => "fab fa-youtube",
			"link_url" => "www.youtube.com"
		),
		array(
			"link_text" => "fab fa-linkedin-in",
			"link_url" => "www.linkedin.com"
		)
	));

	$fashion_shop_storefront_product_image_gallery = array();
	$fashion_shop_storefront_product_ids = array();

	$fashion_shop_storefront_product_category= array(
		'Product Category'       => array(
			'Small Wallet',
			'Acoustic Guitar Linden Wood',
			'Trekking Shoes',
			'Eames Chair',
		),
	);
	
	$fashion_shop_storefront_k = 1;
	foreach ( $fashion_shop_storefront_product_category as $fashion_shop_storefront_product_cats => $fashion_shop_storefront_products_name ) { 
	// Insert porduct cats Start
	$content = 'This is sample product category';
	$fashion_shop_storefront_parent_category	=	wp_insert_term(
	$fashion_shop_storefront_product_cats, // the term
	'product_cat', // the taxonomy
		array(
		'description'=> $content,
		'slug' => str_replace( ' ', '-', $fashion_shop_storefront_product_cats)
		)
	);

// -------------- create subcategory END -----------------

	$fashion_shop_storefront_n=1;
	// create Product START
	foreach ( $fashion_shop_storefront_products_name as $key => $fashion_shop_storefront_product_title ) {
	$content = '
		<div class="main_content">
		<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>
		</div>';

	// Create post object
	$fashion_shop_storefront_my_post = array(
		'post_title'    => wp_strip_all_tags( $fashion_shop_storefront_product_title ),
		'post_content'  => $content,
		'post_status'   => 'publish',
		'post_type'     => 'product',
		'post_category' => [$fashion_shop_storefront_parent_category['term_id']]
	);

	// Insert the post into the database

	$fashion_shop_storefront_uqpost_id = wp_insert_post($fashion_shop_storefront_my_post);
	wp_set_object_terms( $fashion_shop_storefront_uqpost_id, str_replace( ' ', '-', $fashion_shop_storefront_product_cats), 'product_cat', true );

	$fashion_shop_storefront_product_price = array('99','99','99','99');
	$fashion_shop_storefront_product_regular_price = array('100','100','100','100');
	$fashion_shop_storefront_product_sale_price = array('99','99','99','99');
	
	update_post_meta( $fashion_shop_storefront_uqpost_id, '_regular_price', $fashion_shop_storefront_product_regular_price[$fashion_shop_storefront_n-1] );
	update_post_meta( $fashion_shop_storefront_uqpost_id, '_price', $fashion_shop_storefront_product_price[$fashion_shop_storefront_n-1] );
	update_post_meta( $fashion_shop_storefront_uqpost_id, '_sale_price', $fashion_shop_storefront_product_sale_price[$fashion_shop_storefront_n-1] );
	array_push( $fashion_shop_storefront_product_ids,  $fashion_shop_storefront_uqpost_id );

	// Now replace meta w/ new updated value array
	$fashion_shop_storefront_image_url = get_template_directory_uri().'/assets/images/product/'.$fashion_shop_storefront_product_cats.'/' . str_replace(' ', '_', strtolower($fashion_shop_storefront_product_title)).'.png';
	$fashion_shop_storefront_image_name  = $fashion_shop_storefront_product_title.'.png';
	$fashion_shop_storefront_upload_dir = wp_upload_dir();
	// Set upload folder
	$fashion_shop_storefront_image_data = file_get_contents(esc_url($fashion_shop_storefront_image_url));
	// Get image data
	$unique_file_name = wp_unique_filename($fashion_shop_storefront_upload_dir['path'], $fashion_shop_storefront_image_name);
	// Generate unique name
	$fashion_shop_storefront_filename = basename($unique_file_name);
	// Create image file name
	// Check folder permission and define file location
	if (wp_mkdir_p($fashion_shop_storefront_upload_dir['path'])) {
	$fashion_shop_storefront_file = $fashion_shop_storefront_upload_dir['path'].'/'.$fashion_shop_storefront_filename;
	} else {
	$fashion_shop_storefront_file = $fashion_shop_storefront_upload_dir['basedir'].'/'.$fashion_shop_storefront_filename;
	}
	
	file_put_contents($fashion_shop_storefront_file, $fashion_shop_storefront_image_data);
	// Check image file type
	$wp_filetype = wp_check_filetype($fashion_shop_storefront_filename, null);
	// Set attachment data
	$attachment = array(
	'post_mime_type' => $wp_filetype['type'],
	'post_title'     => sanitize_file_name($fashion_shop_storefront_filename),
	'post_type'      => 'product',
	'post_status'    => 'inherit',
	);

	// Create the attachment
	$fashion_shop_storefront_attach_id = wp_insert_attachment($attachment, $fashion_shop_storefront_file, $fashion_shop_storefront_uqpost_id);

	// Define attachment metadata
	$attach_data = wp_generate_attachment_metadata($fashion_shop_storefront_attach_id, $fashion_shop_storefront_file);

	// Assign metadata to attachment
	wp_update_attachment_metadata($fashion_shop_storefront_attach_id, $attach_data);
	if ( count( $fashion_shop_storefront_product_image_gallery ) < 3 ) {
		array_push( $fashion_shop_storefront_product_image_gallery, $fashion_shop_storefront_attach_id );
	}
	// // And finally assign featured image to post
	set_post_thumbnail($fashion_shop_storefront_uqpost_id, $fashion_shop_storefront_attach_id);
	++$fashion_shop_storefront_n;
	}
	// Create product END
	++$fashion_shop_storefront_k;
	}
	// Add Gallery in first simple product and second variable product START
	$fashion_shop_storefront_product_image_gallery = implode( ',', $fashion_shop_storefront_product_image_gallery );
	foreach ( $fashion_shop_storefront_product_ids as $fashion_shop_storefront_product_id ) {
	update_post_meta( $fashion_shop_storefront_product_id, 'fashion_shop_storefront_product_image_gallery', $fashion_shop_storefront_product_image_gallery );
	}
}

}
 