<?php
if ( ! class_exists( 'Fashion_Shop_Storefront_Plugin_Activation_WPElemento_Importer' ) ) {
    /**
     * Fashion_Shop_Storefront_Plugin_Activation_WPElemento_Importer initial setup
     *
     * @since 1.6.2
     */

    class Fashion_Shop_Storefront_Plugin_Activation_WPElemento_Importer {

        private static $fashion_shop_storefront_instance;
        public $fashion_shop_storefront_action_count;
        public $fashion_shop_storefront_recommended_actions;

        /** Initiator **/
        public static function get_instance() {
          if ( ! isset( self::$fashion_shop_storefront_instance) ) {
            self::$fashion_shop_storefront_instance = new self();
          }
          return self::$fashion_shop_storefront_instance;
        }

        /*  Constructor */
        public function __construct() {

            add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

            // ---------- wpelementoimpoter Plugin Activation -------
            add_filter( 'fashion_shop_storefront_recommended_plugins', array($this, 'fashion_shop_storefront_recommended_elemento_importer_plugins_array') );

            $fashion_shop_storefront_actions                   = $this->fashion_shop_storefront_get_recommended_actions();
            $this->fashion_shop_storefront_action_count        = $fashion_shop_storefront_actions['count'];
            $this->fashion_shop_storefront_recommended_actions = $fashion_shop_storefront_actions['actions'];

            add_action( 'wp_ajax_create_pattern_setup_builder', array( $this, 'create_pattern_setup_builder' ) );
        }

        public function fashion_shop_storefront_recommended_elemento_importer_plugins_array($fashion_shop_storefront_plugins){
            $fashion_shop_storefront_plugins[] = array(
                    'name'     => esc_html__('WPElemento Importer', 'fashion-shop-storefront'),
                    'slug'     =>  'wpelemento-importer',
                    'function' => 'WPElemento_Importer_ThemeWhizzie',
                    'desc'     => esc_html__('We highly recommend installing the WPElemento Importer plugin for importing the demo content with Elementor.', 'fashion-shop-storefront'),               
            );
            return $fashion_shop_storefront_plugins;
        }

        public function enqueue_scripts() {
            wp_enqueue_script('updates');      
            wp_register_script( 'fashion-shop-storefront-plugin-activation-script', esc_url(get_template_directory_uri()) . '/includes/getstart/js/plugin-activation.js', array('jquery') );
            wp_localize_script('fashion-shop-storefront-plugin-activation-script', 'fashion_shop_storefront_plugin_activate_plugin',
                array(
                    'installing' => esc_html__('Installing', 'fashion-shop-storefront'),
                    'activating' => esc_html__('Activating', 'fashion-shop-storefront'),
                    'error' => esc_html__('Error', 'fashion-shop-storefront'),
                    'ajax_url' => esc_url(admin_url('admin-ajax.php')),
                    'wpelementoimpoter_admin_url' => esc_url(admin_url('admin.php?page=wpelemento-importer-tgmpa-install-plugins')),
                    'addon_admin_url' => esc_url(admin_url('admin.php?page=wpelementoimporter-wizard'))
                )
            );
            wp_enqueue_script( 'fashion-shop-storefront-plugin-activation-script' );

        }

        // --------- Plugin Actions ---------
        public function fashion_shop_storefront_get_recommended_actions() {

            $fashion_shop_storefront_act_count  = 0;
            $fashion_shop_storefront_actions_todo = get_option( 'recommending_actions', array());

            $fashion_shop_storefront_plugins = $this->fashion_shop_storefront_get_recommended_plugins();

            if ($fashion_shop_storefront_plugins) {
                foreach ($fashion_shop_storefront_plugins as $fashion_shop_storefront_key => $fashion_shop_storefront_plugin) {
                    $fashion_shop_storefront_action = array();
                    if (!isset($fashion_shop_storefront_plugin['slug'])) {
                        continue;
                    }

                    $fashion_shop_storefront_action['id']   = 'install_' . $fashion_shop_storefront_plugin['slug'];
                    $fashion_shop_storefront_action['desc'] = '';
                    if (isset($fashion_shop_storefront_plugin['desc'])) {
                        $fashion_shop_storefront_action['desc'] = $fashion_shop_storefront_plugin['desc'];
                    }

                    $fashion_shop_storefront_action['name'] = '';
                    if (isset($fashion_shop_storefront_plugin['name'])) {
                        $fashion_shop_storefront_action['title'] = $fashion_shop_storefront_plugin['name'];
                    }

                    $fashion_shop_storefront_link_and_is_done  = $this->fashion_shop_storefront_get_plugin_buttion($fashion_shop_storefront_plugin['slug'], $fashion_shop_storefront_plugin['name'], $fashion_shop_storefront_plugin['function']);
                    $fashion_shop_storefront_action['link']    = $fashion_shop_storefront_link_and_is_done['button'];
                    $fashion_shop_storefront_action['is_done'] = $fashion_shop_storefront_link_and_is_done['done'];
                    if (!$fashion_shop_storefront_action['is_done'] && (!isset($fashion_shop_storefront_actions_todo[$fashion_shop_storefront_action['id']]) || !$fashion_shop_storefront_actions_todo[$fashion_shop_storefront_action['id']])) {
                        $fashion_shop_storefront_act_count++;
                    }
                    $fashion_shop_storefront_recommended_actions[] = $fashion_shop_storefront_action;
                    $fashion_shop_storefront_actions_todo[]        = array('id' => $fashion_shop_storefront_action['id'], 'watch' => true);
                }
                return array('count' => $fashion_shop_storefront_act_count, 'actions' => $fashion_shop_storefront_recommended_actions);
            }

        }

        public function fashion_shop_storefront_get_recommended_plugins() {

            $fashion_shop_storefront_plugins = apply_filters('fashion_shop_storefront_recommended_plugins', array());
            return $fashion_shop_storefront_plugins;
        }

        public function fashion_shop_storefront_get_plugin_buttion($slug, $name, $function) {
                $fashion_shop_storefront_is_done      = false;
                $fashion_shop_storefront_button_html  = '';
                $fashion_shop_storefront_is_installed = $this->is_plugin_installed($slug);
                $fashion_shop_storefront_plugin_path  = $this->get_plugin_basename_from_slug($slug);
                $fashion_shop_storefront_is_activeted = (class_exists($function)) ? true : false;
                if (!$fashion_shop_storefront_is_installed) {
                    $fashion_shop_storefront_plugin_install_url = add_query_arg(
                        array(
                            'action' => 'install-plugin',
                            'plugin' => $slug,
                        ),
                        self_admin_url('update.php')
                    );
                    $fashion_shop_storefront_plugin_install_url = wp_nonce_url($fashion_shop_storefront_plugin_install_url, 'install-plugin_' . esc_attr($slug));
                    $fashion_shop_storefront_button_html        = sprintf('<a class="fashion-shop-storefront-plugin-install install-now button-secondary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($fashion_shop_storefront_plugin_install_url),
                        sprintf(esc_html__('Install %s Now', 'fashion-shop-storefront'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Install & Activate', 'fashion-shop-storefront')
                    );
                } elseif ($fashion_shop_storefront_is_installed && !$fashion_shop_storefront_is_activeted) {

                    $fashion_shop_storefront_plugin_activate_link = add_query_arg(
                        array(
                            'action'        => 'activate',
                            'plugin'        => rawurlencode($fashion_shop_storefront_plugin_path),
                            'plugin_status' => 'all',
                            'paged'         => '1',
                            '_wpnonce'      => wp_create_nonce('activate-plugin_' . $fashion_shop_storefront_plugin_path),
                        ), self_admin_url('plugins.php')
                    );

                    $fashion_shop_storefront_button_html = sprintf('<a class="fashion-shop-storefront-plugin-activate activate-now button-primary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($fashion_shop_storefront_plugin_activate_link),
                        sprintf(esc_html__('Activate %s Now', 'fashion-shop-storefront'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Activate', 'fashion-shop-storefront')
                    );
                } elseif ($fashion_shop_storefront_is_activeted) {
                    $fashion_shop_storefront_button_html = sprintf('<div class="action-link button disabled"><span class="dashicons dashicons-yes"></span> %s</div>', esc_html__('Active', 'fashion-shop-storefront'));
                    $fashion_shop_storefront_is_done     = true;
                }

                return array('done' => $fashion_shop_storefront_is_done, 'button' => $fashion_shop_storefront_button_html);
            }
        public function is_plugin_installed($slug) {
            $fashion_shop_storefront_installed_plugins = $this->get_installed_plugins(); // Retrieve a list of all installed plugins (WP cached).
            $fashion_shop_storefront_file_path         = $this->get_plugin_basename_from_slug($slug);
            return (!empty($fashion_shop_storefront_installed_plugins[$fashion_shop_storefront_file_path]));
        }
        public function get_plugin_basename_from_slug($slug) {
            $fashion_shop_storefront_keys = array_keys($this->get_installed_plugins());
            foreach ($fashion_shop_storefront_keys as $fashion_shop_storefront_key) {
                if (preg_match('|^' . $slug . '/|', $fashion_shop_storefront_key)) {
                    return $fashion_shop_storefront_key;
                }
            }
            return $slug;
        }

        public function get_installed_plugins() {

            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            return get_plugins();
        }
        public function create_pattern_setup_builder() {

            $edit_page = admin_url().'post-new.php?post_type=page&create_pattern=true';
            echo json_encode(['page_id'=>'','edit_page_url'=> $edit_page ]);

            exit;
        }

    }
}
/**
 * Kicking this off by calling 'get_instance()' method
 */
Fashion_Shop_Storefront_Plugin_Activation_WPElemento_Importer::get_instance();