<?php

function get_page_id_by_title($fashion_shop_storefront_pagename){
  $fashion_shop_storefront_args = array(
 'post_type' => 'page',
 'posts_per_page' => 1,
 'title' => $fashion_shop_storefront_pagename
  );
  $fashion_shop_storefront_query = new WP_Query( $fashion_shop_storefront_args );    $fashion_shop_storefront_page_id = '1';
 if (isset($fashion_shop_storefront_query->post->ID)) {
      $fashion_shop_storefront_page_id = $fashion_shop_storefront_query->post->ID;
  } return $fashion_shop_storefront_page_id;
}
//about theme info
add_action( 'admin_menu', 'fashion_shop_storefront_gettingstarted' );
function fashion_shop_storefront_gettingstarted() {
	add_theme_page( esc_html__('Fashion Shop Storefront', 'fashion-shop-storefront'), esc_html__('Fashion Shop Storefront', 'fashion-shop-storefront'), 'edit_theme_options', 'fashion_shop_storefront_about', 'fashion_shop_storefront_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function fashion_shop_storefront_admin_theme_style() {
	wp_enqueue_style('fashion-shop-storefront-custom-admin-style', esc_url(get_template_directory_uri()) . '/includes/getstart/getstart.css');
	wp_enqueue_script('fashion-shop-storefront-tabs', esc_url(get_template_directory_uri()) . '/includes/getstart/js/tab.js');
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/assets/css/fontawesome-all.css' );

	// Admin notice code START
	wp_register_script('fashion-shop-storefront-notice', esc_url(get_template_directory_uri()) . '/includes/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('fashion-shop-storefront-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'fashion_shop_storefront_admin_theme_style');

// Changelog
if ( ! defined( 'FASHION_SHOP_STOREFRONT_CHANGELOG_URL' ) ) {
    define( 'FASHION_SHOP_STOREFRONT_CHANGELOG_URL', get_template_directory() . '/readme.txt' );
}

function fashion_shop_storefront_changelog_screen() {
	global $wp_filesystem;
	$fashion_shop_storefront_changelog_file = apply_filters( 'fashion_shop_storefront_changelog_file', FASHION_SHOP_STOREFRONT_CHANGELOG_URL );

	if ( $fashion_shop_storefront_changelog_file && is_readable( $fashion_shop_storefront_changelog_file ) ) {
		WP_Filesystem();
		$fashion_shop_storefront_changelog = $wp_filesystem->get_contents( $fashion_shop_storefront_changelog_file );
		$fashion_shop_storefront_changelog_list = fashion_shop_storefront_parse_changelog( $fashion_shop_storefront_changelog );

		
		echo '<div id="fashion-shop-storefront-changelog-container">';
		echo wp_kses_post( $fashion_shop_storefront_changelog_list );
		echo '</div>';
		echo '<button id="fashion-shop-storefront-load-more" class="button button-primary" style="margin-top:15px;">Load More</button>';
	}
}

function fashion_shop_storefront_parse_changelog( $fashion_shop_storefront_content ) {
	$fashion_shop_storefront_content = explode ( '== ', $fashion_shop_storefront_content );
	$fashion_shop_storefront_changelog_isolated = '';

	foreach ( $fashion_shop_storefront_content as $key => $fashion_shop_storefront_value ) {
		if ( strpos( $fashion_shop_storefront_value, 'Changelog ==' ) === 0 ) {
	    	$fashion_shop_storefront_changelog_isolated = str_replace( 'Changelog ==', '', $fashion_shop_storefront_value );
	    }
	}

	$fashion_shop_storefront_changelog_array = explode( '= ', $fashion_shop_storefront_changelog_isolated );
	unset( $fashion_shop_storefront_changelog_array[0] );

	$fashion_shop_storefront_changelog = '<div class="changelog">';
	foreach ( $fashion_shop_storefront_changelog_array as $fashion_shop_storefront_value ) {
		$fashion_shop_storefront_value = preg_replace( '/\n+/', '</span><span>', $fashion_shop_storefront_value );
		$fashion_shop_storefront_value = '<div class="block-changelog"><span class="heading">= ' . $fashion_shop_storefront_value . '</span></div>';
		$fashion_shop_storefront_changelog .= str_replace( '<span></span>', '', $fashion_shop_storefront_value );
	}
	$fashion_shop_storefront_changelog .= '</div>';

	return wp_kses_post( $fashion_shop_storefront_changelog );
}

//guidline for about theme
function fashion_shop_storefront_mostrar_guide() { 
	//custom function about theme customizer
	$fashion_shop_storefront_return = add_query_arg( array()) ;
	$fashion_shop_storefront_theme = wp_get_theme( 'fashion-shop-storefront' );
	?>
<div class="container-getstarted">
		<div class="inner-side-content1">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/sticky-header-logo.png" />
			</div>
		    <div class="coupon-container-box-left">
			    <div class="iner-sidebar-pro-btn">
				    <span class="premium-btn"><a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium Theme', 'fashion-shop-storefront'); ?></a>
				    </span>
			    </div>
		    </div>
        </div>					
   <div class="top-head">
	    <div class="top-title">
		     <h2><?php esc_html_e( 'Fashion Shop Storefront', 'fashion-shop-storefront' ); ?></h2>
		     <h4><?php esc_html_e( 'Welcome to WP Elemento Theme!', 'fashion-shop-storefront' ); ?></h4>
		     <p><?php esc_html_e( 'Click on the quick start button to import the demo.', 'fashion-shop-storefront' ); ?></p>
			    <div class="iner-sidebar-pro-btn">
					<?php if(!class_exists('WPElemento_Importer_ThemeWhizzie')){
						$fashion_shop_storefront_plugin_ins = Fashion_Shop_Storefront_Plugin_Activation_WPElemento_Importer::get_instance();
						$fashion_shop_storefront_actions = $fashion_shop_storefront_plugin_ins->fashion_shop_storefront_recommended_actions;
					?>
					<div class="fashion-shop-storefront-recommended-plugins ">
						<div class="fashion-shop-storefront-action-list">
							<?php if ($fashion_shop_storefront_actions): foreach ($fashion_shop_storefront_actions as $fashion_shop_storefront_key => $fashion_shop_storefront_actionValue): ?>
									<div class="fashion-shop-storefront-action" id="<?php echo esc_attr($fashion_shop_storefront_actionValue['id']);?>">
										<div class="action-inner plugin-activation-redirect">
											<?php echo wp_kses_post($fashion_shop_storefront_actionValue['link']); ?>
										</div>
									</div>
								<?php endforeach;
							endif; ?>
						</div>
					</div>
				   <?php }else{ ?>
					<span class="quick-btn">
				    <?php if (isset($_GET['imported']) && $_GET['imported'] == 'true'): ?>
                        <a href="<?php echo esc_url( site_url() ); ?>" target="_blank"><?php esc_html_e('Visit Site', 'fashion-shop-storefront'); ?></a>
						<?php
						$fashion_shop_storefront_page_id = get_page_id_by_title('Home');
						?>
						<a href="<?php echo esc_url( admin_url('post.php?post=' . $fashion_shop_storefront_page_id . '&action=elementor') ); ?>" 
							target="_blank" class="elementor-edit-btn"><?php esc_html_e('Edit With Elementor', 'fashion-shop-storefront'); ?>
						</a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=wpelementoimporter-wizard') ); ?>"><?php esc_html_e('Quick Start', 'fashion-shop-storefront'); ?></a>
                    <?php endif; ?>
					<?php } ?>
				   </span>
				    <span class="premium-btn"><a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium', 'fashion-shop-storefront'); ?></a>
				    </span>
				    <span class="demo-btn"><a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'fashion-shop-storefront'); ?></a>
				    </span>
				    <span class="doc-btn"><a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Theme Bundle at $79', 'fashion-shop-storefront'); ?></a>
				    </span>
			    </div>
            </div>			
		<div class="inner-side-content">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" />
			</div>
			<div class="top-right">
			  <span class="version"><?php esc_html_e( 'Version', 'fashion-shop-storefront' ); ?>: <?php echo esc_html($fashion_shop_storefront_theme['Version']);?></span>
		    </div>
		</div>
    </div>
    <div class="inner-cont">
	    <div class="tab-outer-box1">
		   <div class="tab-inner-box">
			   <div class= "bundle-box">
				    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/bundle.png"/>
				    <h1><?php esc_html_e('ELEMENTOR WORDPRESS THEME BUNDLE', 'fashion-shop-storefront'); ?></h1>
			     <div>
				    <p class="product-price"><?php esc_html_e('Price:', 'fashion-shop-storefront'); ?>
                        <span class="regular-price"><?php esc_html_e('$1,999.00', 'fashion-shop-storefront'); ?></span>
                        <span class="sale-price"><?php esc_html_e('$79.00', 'fashion-shop-storefront'); ?></span>
                    </p>
					<p><?php esc_html_e('The Elementor WordPress Theme Bundle offers a stunning collection of 76+ Premium Elementor Themes', 'fashion-shop-storefront'); ?></p>
                 </div>
				</div> 
			    <div class="offer-box"> 
				    <div class="offer1-box">
                       <span class="off-text1"><a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Buy Bundle at 20% Discount', 'fashion-shop-storefront'); ?></a></span>
				    </div> 
		        </div>
			</div>	
		</div>	
		<div class="tab-outer-box2">
			<div class="tab-outer-box-2-1">
			  <h3><?php esc_html_e( 'Customizer Setting', 'fashion-shop-storefront' ); ?></h3>
			  <div class="lite-theme-inner">
				<div>
					<h3><?php esc_html_e('Theme Customizer', 'fashion-shop-storefront'); ?></h3>
					<p><?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'fashion-shop-storefront'); ?></p>
					<div class="info-link">
					   <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Open customizer', 'fashion-shop-storefront'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Help Docs', 'fashion-shop-storefront'); ?></h3>
					<p><?php esc_html_e('The complete procedure to configure and manage a WordPress Website from the beginning is shown in this documentation .', 'fashion-shop-storefront'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'fashion-shop-storefront'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Need Support?', 'fashion-shop-storefront'); ?></h3>
					<p><?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'fashion-shop-storefront'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'fashion-shop-storefront'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Reviews & Testimonials', 'fashion-shop-storefront'); ?></h3>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'fashion-shop-storefront'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( FASHION_SHOP_STOREFRONT_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'fashion-shop-storefront'); ?></a>
					</div>
				</div>
            </div>	
		</div>
			<div class="tab-outer-box-2-2">
			  <h3><?php esc_html_e( 'Link to customizer', 'fashion-shop-storefront' ); ?></h3>
				<div class="first-row">
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your Website logo','fashion-shop-storefront'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Edit Your Menus','fashion-shop-storefront'); ?></a>
						</div>
					</div>
							
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=header_image') ); ?>" target="_blank"><?php esc_html_e('Add Header Image','fashion-shop-storefront'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Add Footer Widget','fashion-shop-storefront'); ?></a>
						</div>
					</div>
				</div>
            </div>	
			<div class="tab-outer-box-2-3">
				<h3><?php esc_html_e( 'Change log', 'fashion-shop-storefront' ); ?></h3>	
		     <?php fashion_shop_storefront_changelog_screen(); ?>
          </div>	
        </div>
    </div>
</div>	
<?php } ?>