<?php

if ( class_exists("Kirki")){

	Kirki::add_config('theme_config_id', array(
		'capability'   =>  'edit_theme_options',
		'option_type'  =>  'theme_mod',
	));

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'fashion_shop_storefront_logo_resizer',
		'label'       => esc_html__( 'Adjust Logo Size', 'fashion-shop-storefront' ),
		'section'     => 'title_tagline',
		'default'     => 70,
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

  	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'fashion_shop_storefront_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'fashion-shop-storefront' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'fashion_shop_storefront_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'fashion-shop-storefront' ),
		'section'     => 'title_tagline',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_site_tittle_font_heading',
		'section'     => 'title_tagline',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Site Title Font Size', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_site_tittle_font_size',
		'type'        => 'number',
		'section'     => 'title_tagline',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.logo a'),
				'property' => 'font-size',
				'suffix' => 'px'
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_site_tagline_font_heading',
		'section'     => 'title_tagline',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Site Tagline Font Size', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_site_tagline_font_size',
		'type'        => 'number',
		'section'     => 'title_tagline',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.logo span'),
				'property' => 'font-size',
				'suffix' => 'px'
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_site_tittle_transform_heading',
		'section'     => 'title_tagline',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Site Title Text Transform', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'settings'    => 'fashion_shop_storefront_site_tittle_transform',
		'section'     => 'title_tagline',
		'default'     => 'capitalize',
		'choices'     => [
			'none' => esc_html__( 'Normal', 'fashion-shop-storefront' ),
			'uppercase' => esc_html__( 'Uppercase', 'fashion-shop-storefront' ),
			'lowercase' => esc_html__( 'Lowercase', 'fashion-shop-storefront' ),
			'capitalize' => esc_html__( 'Capitalize', 'fashion-shop-storefront' ),
		],
		'output' => array(
			array(
				'element'  => array( '.logo a'),
				'property' => ' text-transform',
			),
		),
	 ) );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_logo_settings_premium_features',
		'section'     => 'title_tagline',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Unlock More Features in the Premium Version!', 'fashion-shop-storefront' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Customizable Text Logo', 'fashion-shop-storefront' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Enhanced Typography Options', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Priority Support', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'fashion-shop-storefront' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/fashion-shop-wordpress-theme', 'fashion-shop-storefront' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'fashion-shop-storefront' ) .'</a></div>',
	) );

	// Theme color

	Kirki::add_section( 'fashion_shop_storefront_theme_color_setting', array(
		'title'    => __( 'Color Option', 'fashion-shop-storefront' ),
		'priority' => 10,
	) );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_theme_color',
		'label'       => __( 'Theme color', 'fashion-shop-storefront'),
		'description'    => esc_html__( 'To customize the colors of the homepage, use the Elementor editor', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_theme_color_setting',
		'type'        => 'color',
		'default'     => '#fc1a1a',
	) );

	// TYPOGRAPHY SETTINGS

	Kirki::add_panel( 'fashion_shop_storefront_typography_panel', array(
		'priority' => 10,
		'title'    => __( 'Typography', 'fashion-shop-storefront' ),
	) );

	//Heading 1 Section

	Kirki::add_section( 'fashion_shop_storefront_h1_typography_setting', array(
		'title'    => __( 'Heading 1', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h1_typography_heading',
		'section'     => 'fashion_shop_storefront_h1_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 1 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h1_typography_font',
		'section'   =>  'fashion_shop_storefront_h1_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h1',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 2 Section

	Kirki::add_section( 'fashion_shop_storefront_h2_typography_setting', array(
		'title'    => __( 'Heading 2', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h2_typography_heading',
		'section'     => 'fashion_shop_storefront_h2_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 2 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h2_typography_font',
		'section'   =>  'fashion_shop_storefront_h2_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'font-size'       => '',
			'variant'       =>  '700',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h2',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 3 Section

	Kirki::add_section( 'fashion_shop_storefront_h3_typography_setting', array(
		'title'    => __( 'Heading 3', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h3_typography_heading',
		'section'     => 'fashion_shop_storefront_h3_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 3 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h3_typography_font',
		'section'   =>  'fashion_shop_storefront_h3_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h3',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 4 Section

	Kirki::add_section( 'fashion_shop_storefront_h4_typography_setting', array(
		'title'    => __( 'Heading 4', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h4_typography_heading',
		'section'     => 'fashion_shop_storefront_h4_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 4 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h4_typography_font',
		'section'   =>  'fashion_shop_storefront_h4_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h4',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 5 Section

	Kirki::add_section( 'fashion_shop_storefront_h5_typography_setting', array(
		'title'    => __( 'Heading 5', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h5_typography_heading',
		'section'     => 'fashion_shop_storefront_h5_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 5 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h5_typography_font',
		'section'   =>  'fashion_shop_storefront_h5_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h5',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 6 Section

	Kirki::add_section( 'fashion_shop_storefront_h6_typography_setting', array(
		'title'    => __( 'Heading 6', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_h6_typography_heading',
		'section'     => 'fashion_shop_storefront_h6_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 6 Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_h6_typography_font',
		'section'   =>  'fashion_shop_storefront_h6_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h6',
				'suffix' => '!important'
			],
		],
	) );

	//body Typography

	Kirki::add_section( 'fashion_shop_storefront_body_typography_setting', array(
		'title'    => __( 'Content Typography', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_body_typography_heading',
		'section'     => 'fashion_shop_storefront_body_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Content  Typography', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'fashion_shop_storefront_body_typography_font',
		'section'   =>  'fashion_shop_storefront_body_typography_setting',
		'default'   =>  [
			'font-family'   =>  'Inter',
			'variant'       =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   => 'body',
				'suffix' => '!important'
			],
		],
	) );

	// Theme Options Panel
	Kirki::add_panel( 'fashion_shop_storefront_theme_options_panel', array(
		'priority' => 10,
		'title'    => __( 'Theme Options', 'fashion-shop-storefront' ),
	) );
	
	// HEADER SECTION

	Kirki::add_section( 'fashion_shop_storefront_section_header',array(
		'title' => esc_html__( 'Header Settings', 'fashion-shop-storefront' ),
		'description'    => esc_html__( 'Here you can add header information.', 'fashion-shop-storefront' ),
		'panel' => 'fashion_shop_storefront_theme_options_panel',
		'tabs'  => [
			'header' => [
				'label' => esc_html__( 'Header', 'fashion-shop-storefront' ),
			],
			'menu'  => [
				'label' => esc_html__( 'Menu', 'fashion-shop-storefront' ),
			],
		],
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'tab'      => 'header',
		'priority'       => 1,
		'settings'    => 'fashion_shop_storefront_sticky_header',
		'label'       => esc_html__( 'Enable/Disable Sticky Header', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 0,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'menu',
		'settings'    => 'fashion_shop_storefront_menu_size_heading',
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Menu Font Size(px)', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_menu_size',
		'label'       => __( 'Enter a value in pixels. Example:20px', 'fashion-shop-storefront' ),
		'type'        => 'text',
		'tab'      => 'menu',
		'section'     => 'fashion_shop_storefront_section_header',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array( '#main-menu a', '#main-menu ul li a', '#main-menu li a'),
				'property' => 'font-size',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'menu',
		'settings'    => 'fashion_shop_storefront_menu_text_transform_heading',
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Menu Text Transform', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'menu',
		'settings'    => 'fashion_shop_storefront_menu_text_transform',
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 'uppercase',
		'choices'     => [
			'none' => esc_html__( 'Normal', 'fashion-shop-storefront' ),
			'uppercase' => esc_html__( 'Uppercase', 'fashion-shop-storefront' ),
			'lowercase' => esc_html__( 'Lowercase', 'fashion-shop-storefront' ),
			'capitalize' => esc_html__( 'Capitalize', 'fashion-shop-storefront' ),
		],
		'output' => array(
			array(
				'element'  => array( '#main-menu a', '#main-menu ul li a', '#main-menu li a'),
				'property' => ' text-transform',
			),
		),
	 ) );

	Kirki::add_field( 'theme_config_id', [
		'label'    =>  esc_html__( 'Add Topbar Text', 'fashion-shop-storefront' ),
		'type'     => 'text',
		'tab'      => 'header',
		'settings' => 'fashion_shop_storefront_header_toptxt',
		'section'  => 'fashion_shop_storefront_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_google_translator',
		'label'       => esc_html__( 'Language Translator', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 1,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_currency_switcher',
		'label'       => esc_html__( 'Currency Switcher', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 1,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_disable_search_icon',
		'label'       => esc_html__( 'Enable/Disable Search', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'tab'      => 'header',
		'label'    =>  esc_html__( 'Wishlist Link', 'fashion-shop-storefront' ),
		'settings' => 'fashion_shop_storefront_header_wishlist_url',
		'section'  => 'fashion_shop_storefront_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_cart_box_enable',
		'label'       => esc_html__( 'Enable/Disable Shopping Cart', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_header_phone_number_heading',
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Phone Number', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'label'    =>  esc_html__( 'Text', 'fashion-shop-storefront' ),
		'settings' => 'fashion_shop_storefront_header_phone_number_text',
		'section'  => 'fashion_shop_storefront_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'label'    =>  esc_html__( 'Phone Number', 'fashion-shop-storefront' ),
		'settings' => 'fashion_shop_storefront_header_phone_number',
		'section'  => 'fashion_shop_storefront_section_header',
		'default'  => '',
		'sanitize_callback' => 'fashion_shop_storefront_sanitize_phone_number',
	] );
	
	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_enable_socail_link',
		'section'     => 'fashion_shop_storefront_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'tab'      => 'header',
		'section'     => 'fashion_shop_storefront_section_header',
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'fashion-shop-storefront' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'fashion-shop-storefront' ),
		'settings'     => 'fashion_shop_storefront_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'fashion-shop-storefront' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'fashion-shop-storefront' ). ' <a href="https://fontawesome.com/search?o=r&m=free&f=brands" target="_blank"><strong>' . esc_html__( 'View All', 'fashion-shop-storefront' ) . ' </strong></a>',
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'fashion-shop-storefront' ),
				'description' => esc_html__( 'Add the social icon url here.', 'fashion-shop-storefront' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 20
		],
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'fashion_shop_storefront_logo_settings_premium_features_header',
		'section'     => 'fashion_shop_storefront_section_header',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Enhance your header design now!', 'fashion-shop-storefront' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Customize your header background color', 'fashion-shop-storefront' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Adjust icon and text font sizes', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Explore enhanced typography options', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'fashion-shop-storefront' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/fashion-shop-wordpress-theme', 'fashion-shop-storefront' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'fashion-shop-storefront' ) .'</a></div>',
	) );

	//ADDITIONAL SETTINGS

	Kirki::add_section( 'fashion_shop_storefront_additional_setting',array(
		'title' => esc_html__( 'Additional Settings', 'fashion-shop-storefront' ),
		'panel' => 'fashion_shop_storefront_theme_options_panel',
		'tabs'  => [
			'general' => [
				'label' => esc_html__( 'General', 'fashion-shop-storefront' ),
			],
			'header-image'  => [
				'label' => esc_html__( 'Header Image', 'fashion-shop-storefront' ),
			],
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_preloader_hide',
		'label'       => esc_html__( 'Here you can enable or disable your preloader.', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '0',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '0',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_enable_sidebar_animation_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Animation', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_enable_sidebar_animation',
		'label'       => esc_html__( 'Enable or Disable Sidebar Animation', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_enable_footer_animation',
		'label'       => esc_html__( 'Enable or Disable Footer Animation', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_enable_sidebar_sticky_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sticky Sidebar', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_enable_sticky_sidebar',
		'label'       => esc_html__( 'Enable or Disable Sticky Sidebar', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_scroll_alignment_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Scroll To Top Position', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'radio-buttonset',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_scroll_alignment',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => 'right',
		'choices'     => [
			'left' => esc_html__( 'left', 'fashion-shop-storefront' ),
			'center' => esc_html__( 'center', 'fashion-shop-storefront' ),
			'right' => esc_html__( 'right', 'fashion-shop-storefront' ),
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_scroller_border_radius_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Scroll To Top Border Radius', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'slider',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_scroller_border_radius',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '3',
		'choices'     => [
			'min'  => 0,
			'max'  => 25,
			'step' => 1,
		],
		'output' => array(
			array(
				'element'  => '.scroll-up a',
				'property' => 'border-radius',
				'units' => 'px',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_cursor_outline_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dot Cursor', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_cursor_outline',
		'label'       => esc_html__( 'Enable or Disable Dot Cursor', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_progress_bar_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_progress_bar',
		'label'       => esc_html__( 'Enable or Disable Progress Bar', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_progress_bar_position_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar Position', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_progress_bar_position',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => 'top',
		'choices'     => [
			'top' => esc_html__( 'Top', 'fashion-shop-storefront' ),
			'bottom' => esc_html__( 'Bottom', 'fashion-shop-storefront' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_progress_bar_color_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar Color', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_progress_bar_color',
		'tab'      => 'general',
		'label'       => __( 'Color', 'fashion-shop-storefront' ),
		'type'        => 'color',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'transport' => 'auto',
		'default'     => '#fc1a1a',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '#elemento-progress-bar',
				'property' => 'background-color',
			),
		),
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_single_page_layout_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Single Page Layout', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'general',
		'settings'    => 'fashion_shop_storefront_single_page_layout',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => 'One Column',
		'choices'     => [
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'fashion-shop-storefront' ),
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'fashion-shop-storefront' ),
			'One Column' => esc_html__( 'One Column', 'fashion-shop-storefront' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_background_attachment_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image Attachment', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_background_attachment',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => 'scroll',
		'choices'     => [
			'scroll' => esc_html__( 'Scroll', 'fashion-shop-storefront' ),
			'fixed' => esc_html__( 'Fixed', 'fashion-shop-storefront' ),
		],
		'output' => array(
			array(
				'element'  => '.header-image-box',
				'property' => 'background-attachment',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_image_height_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image height', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_header_image_height',
		'label'       => __( 'Image Height', 'fashion-shop-storefront' ),
		'description'    => esc_html__( 'Enter a value in pixels. Example:500px', 'fashion-shop-storefront' ),
		'type'        => 'text',
		'tab'      => 'header-image',
		'default'    => [
			'desktop' => '550px',
			'tablet'  => '350px',
			'mobile'  => '200px',
		],
		'responsive' => true,
		'section'     => 'fashion_shop_storefront_additional_setting',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.header-image-box'),
				'property' => 'height',
				'media_query' => [
					'desktop' => '@media (min-width: 1024px)',
					'tablet'  => '@media (min-width: 768px) and (max-width: 1023px)',
					'mobile'  => '@media (max-width: 767px)',
				],
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_overlay_heading',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image Overlay', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_header_overlay_setting',
		'label'       => __( 'Overlay Color', 'fashion-shop-storefront' ),
		'type'        => 'color',
		'tab'      => 'header-image',
		'section'     => 'fashion_shop_storefront_additional_setting',
		'transport' => 'auto',
		'default'     => '#00000080',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '.header-image-box:before',
				'property' => 'background',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_page_title',
		'label'       => esc_html__( 'Enable / Disable Header Image Page Title.', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'header-image',
		'settings'    => 'fashion_shop_storefront_header_breadcrumb',
		'label'       => esc_html__( 'Enable / Disable Header Image Breadcrumb.', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_additional_setting',
		'default'     => '1',
		'priority'    => 10,
	] );
	
	// WOOCOMMERCE SETTINGS

	Kirki::add_section( 'fashion_shop_storefront_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'fashion-shop-storefront' ),
		'panel'    => 'woocommerce',
		'description'    => esc_html__( 'Woocommerce Settings of themes', 'fashion-shop-storefront' ),
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_shop_page_sidebar',
		'label'       => esc_html__( 'Enable/Disable Shop Page Sidebar', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => 'true',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Shop Page Layouts', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_shop_page_layout',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'fashion-shop-storefront' ),
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'fashion-shop-storefront' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_shop_page_sidebar',
				'operator' => '===',
				'value'    => true,
			],
		]

	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'label'       => esc_html__( 'Products Per Row', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_products_per_row',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => '3',
		'priority'    => 10,
		'choices'     => [
			'2' => '2',
			'3' => '3',
			'4' => '4',
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'label'       => esc_html__( 'Products Per Page', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_products_per_page',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => '9',
		'priority'    => 10,
		'choices'  => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_single_product_sidebar',
		'label'       => esc_html__( 'Enable / Disable Single Product Sidebar', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => 'true',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Single Product Layout', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_single_product_sidebar_layout',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'fashion-shop-storefront' ),
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'fashion-shop-storefront' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'fashion_shop_storefront_single_product_sidebar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_products_button_border_radius_heading',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Products Button Border Radius', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'fashion_shop_storefront_products_button_border_radius',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
		'choices'  => [
					'min'  => 1,
					'max'  => 50,
					'step' => 1,
				],
		'output' => array(
			array(
				'element'  => array('.woocommerce ul.products li.product .button',' a.checkout-button.button.alt.wc-forward','.woocommerce #respond input#submit', '.woocommerce a.button', '.woocommerce button.button','.woocommerce input.button','.woocommerce #respond input#submit.alt','.woocommerce button.button.alt','.woocommerce input.button.alt'),
				'property' => 'border-radius',
				'units' => 'px',
			),
		),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_sale_badge_position_heading',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sale Badge Position', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );


	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'settings'    => 'fashion_shop_storefront_sale_badge_position',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => 'right',
		'choices'     => [
			'right' => esc_html__( 'Right', 'fashion-shop-storefront' ),
			'left' => esc_html__( 'Left', 'fashion-shop-storefront' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_products_sale_font_size_heading',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sale Font Size', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'text',
		'settings'    => 'fashion_shop_storefront_products_sale_font_size',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'priority'    => 10,
		'output' => array(
			array(
				'element'  => array('.woocommerce span.onsale','.woocommerce ul.products li.product .onsale'),
				'property' => 'font-size',
				'units' => 'px',
			),
		),
	] );
	
	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_show_related_product_heading',
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Related Product', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_show_related_product',
		'label'       => esc_html__( 'Enable or Disable Related Product', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	// POST SECTION

	Kirki::add_section( 'fashion_shop_storefront_blog_post',array(
		'title' => esc_html__( 'Post Settings', 'fashion-shop-storefront' ),
		'description'    => esc_html__( 'Here you can add post information.', 'fashion-shop-storefront' ),
		'panel' => 'fashion_shop_storefront_theme_options_panel',
		'tabs'  => [
			'blog-post' => [
				'label' => esc_html__( 'Blog Post', 'fashion-shop-storefront' ),
			],
			'single-post'  => [
				'label' => esc_html__( 'Single Post', 'fashion-shop-storefront' ),
			],
		],
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_enable_post_animation_heading',
		'section'     => 'fashion_shop_storefront_blog_post',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Animation', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_enable_post_animation',
		'label'       => esc_html__( 'Enable or Disable Blog Post Animation', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_post_layout_heading',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Blog Layout', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_post_layout',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'fashion-shop-storefront' ),
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'fashion-shop-storefront' ),
			'One Column' => esc_html__( 'One Column', 'fashion-shop-storefront' ),
			'Three Columns' => esc_html__( 'Three Columns', 'fashion-shop-storefront' ),
			'Four Columns' => esc_html__( 'Four Columns', 'fashion-shop-storefront' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_date_hide',
		'label'       => esc_html__( 'Enable / Disable Post Date', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_author_hide',
		'label'       => esc_html__( 'Enable / Disable Post Author', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_comment_hide',
		'label'       => esc_html__( 'Enable / Disable Post Comment', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_length_setting_heading',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Blog Post Content Limit', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_length_setting',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '15',
		'priority'    => 10,
		'choices'  => [
					'min'  => -10,
					'max'  => 40,
					'step' => 1,
				],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_show_pagination_heading',
		'section'     => 'fashion_shop_storefront_blog_post',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Blog Post Pagination', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'fashion_shop_storefront_show_pagination',
		'label'       => esc_html__( 'Enable or Disable Blog Post Pagination', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_single_post_date_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Date', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_single_post_author_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Author', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_single_post_comment_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Comment', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'label'       => esc_html__( 'Enable / Disable Single Post Tag', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_single_post_tag',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'label'       => esc_html__( 'Enable / Disable Single Post Category', 'fashion-shop-storefront' ),
		'settings'    => 'fashion_shop_storefront_single_post_category',
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_post_comment_show_hide',
		'label'       => esc_html__( 'Show / Hide Comment Box', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_show_related_post_heading',
		'section'     => 'fashion_shop_storefront_blog_post',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Related post', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'fashion_shop_storefront_show_related_post',
		'label'       => esc_html__( 'Enable or Disable Related post', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_blog_post',
		'default'     => true,
		'priority'    => 10,
	] );

	// No Results Page Settings

	Kirki::add_section( 'fashion_shop_storefront_no_result_section', array(
		'title'          => esc_html__( '404 & No Results Page Settings', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_theme_options_panel',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_page_not_found_title_heading',
		'section'     => 'fashion_shop_storefront_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Page Title', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'fashion_shop_storefront_page_not_found_title',
		'section'  => 'fashion_shop_storefront_no_result_section',
		'default'  => esc_html__('404 Error!', 'fashion-shop-storefront'),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_page_not_found_text_heading',
		'section'     => 'fashion_shop_storefront_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Page Text', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'fashion_shop_storefront_page_not_found_text',
		'section'  => 'fashion_shop_storefront_no_result_section',
		'default'  => esc_html__('The page you are looking for may have been moved, deleted, or possibly never existed.', 'fashion-shop-storefront'),
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'     => 'custom',
		'settings' => 'fashion_shop_storefront_page_not_found_line_break',
		'section'  => 'fashion_shop_storefront_no_result_section',
		'default'  => '<hr>',
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_no_results_title_heading',
		'section'     => 'fashion_shop_storefront_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Results Title', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'fashion_shop_storefront_no_results_title',
		'section'  => 'fashion_shop_storefront_no_result_section',
		'default'  => esc_html__('Nothing Found', 'fashion-shop-storefront'),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_no_results_content_heading',
		'section'     => 'fashion_shop_storefront_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Results Content', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'fashion_shop_storefront_no_results_content',
		'section'  => 'fashion_shop_storefront_no_result_section',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fashion-shop-storefront'),
	] );

	// FOOTER SECTION

	Kirki::add_section( 'fashion_shop_storefront_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'fashion-shop-storefront' ),
        'description'    => esc_html__( 'Here you can change copyright text', 'fashion-shop-storefront' ),
        'panel'    => 'fashion_shop_storefront_theme_options_panel',
		'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_show_footer_widget_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_show_footer_widget',
		'label'       => esc_html__( 'Footer Widget', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_show_footer_copyright',
		'label'       => esc_html__( 'Footer Copyright', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => '1',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_text_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'fashion_shop_storefront_footer_text',
		'section'  => 'fashion_shop_storefront_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_sticky_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Sticky Copyright', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );
	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'fashion_shop_storefront_sticky_copyright_enable',
		'label'       => esc_html__( ' Sticky Copyright Section Enable / Disable', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_enable_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'fashion_shop_storefront_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'fashion-shop-storefront' ),
			'off' => esc_html__( 'Disable', 'fashion-shop-storefront' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_background_widget_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Widget Background', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id',
	[
		'settings'    => 'fashion_shop_storefront_footer_background_widget',
		'type'        => 'background',
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => [
			'background-color'      => 'rgba(18,18,18,1)',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.footer-widget',
			],
		],
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_widget_alignment_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Widget Alignment', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'settings'    => 'fashion_shop_storefront_footer_widget_alignment',
		'section'     => 'fashion_shop_storefront_footer_section',
		'default'     =>[
			'desktop' => 'left',
			'tablet'  => 'left',
			'mobile'  => 'center',
		],
		'responsive' => true,
		'label'       => __( 'Widget Alignment', 'fashion-shop-storefront' ),
		'transport' => 'auto',
		'choices'     => [
			'center' => esc_html__( 'center', 'fashion-shop-storefront' ),
			'right' => esc_html__( 'right', 'fashion-shop-storefront' ),
			'left' => esc_html__( 'left', 'fashion-shop-storefront' ),
		],
		'output' => array(
			array(
				'element'  => '.footer-area',
				'property' => 'text-align',
				'media_query' => [
					'desktop' => '@media (min-width: 1024px)',
					'tablet'  => '@media (min-width: 768px) and (max-width: 1023px)',
					'mobile'  => '@media (max-width: 767px)',
				],
			),
		),
	) );



	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_copright_color_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Copyright Background Color', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_footer_copright_color',
		'type'        => 'color',
		'label'       => __( 'Background Color', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'transport' => 'auto',
		'default'     => '#121212',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '.footer-copyright',
				'property' => 'background',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_copright_text_color_heading',
		'section'     => 'fashion_shop_storefront_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Copyright Text Color', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_footer_copright_text_color',
		'type'        => 'color',
		'label'       => __( 'Text Color', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_section',
		'transport' => 'auto',
		'default'     => '#ffffff',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => array( '.footer-copyright a', '.footer-copyright p'),
				'property' => 'color',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_logo_settings_premium_features_footer',
		'section'     => 'fashion_shop_storefront_footer_section',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Elevate your footer with premium features:', 'fashion-shop-storefront' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Tailor your footer layout', 'fashion-shop-storefront' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Integrate an email subscription form', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Personalize social media icons', 'fashion-shop-storefront' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'fashion-shop-storefront' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/fashion-shop-wordpress-theme', 'fashion-shop-storefront' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'fashion-shop-storefront' ) .'</a></div>',
	) );
	
	// Footer Social Icons Sections

	Kirki::add_section( 'fashion_shop_storefront_footer_social_media_section', array(
		'title'          => esc_html__( 'Footer Social Icons', 'fashion-shop-storefront' ),
		'panel'    => 'fashion_shop_storefront_theme_options_panel',
		'priority'       => 160,
	) );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_footer_social_icon_hide_heading',
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable or Disable your Footer Social Icon', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'fashion_shop_storefront_footer_social_icon_hide',
		'label'       => esc_html__( 'Enable or Disable Social Icon.', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'fashion_shop_storefront_enable_footer_socail_link_align_heading',
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Social Media Text Align', 'fashion-shop-storefront' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'fashion_shop_storefront_enable_footer_socail_link_align',
		'type'        => 'select',
		'priority'    => 10,
		'label'       => __( 'Text Align', 'fashion-shop-storefront' ),
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
		'default'     => 'left',
		'choices'     => [
			'center' => esc_html__( 'center', 'fashion-shop-storefront' ),
			'right' => esc_html__( 'right', 'fashion-shop-storefront' ),
			'left' => esc_html__( 'left', 'fashion-shop-storefront' ),
		],
		'output' => array(
			array(
				'element'  => array( '.footer-links'),
				'property' => 'text-align',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'priority'    => 10,
		'settings'    => 'fashion_shop_storefront_enable_footer_socail_link',
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Social Media Link', 'fashion-shop-storefront' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'priority'    => 10,
		'section'     => 'fashion_shop_storefront_footer_social_media_section',
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icons', 'fashion-shop-storefront' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'fashion-shop-storefront' ),
		'settings'     => 'fashion_shop_storefront_social_links_settings_footer',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'fashion-shop-storefront' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'fashion-shop-storefront' ). ' <a href="https://fontawesome.com/search?o=r&m=free&f=brands" target="_blank"><strong>' . esc_html__( 'View All', 'fashion-shop-storefront' ) . ' </strong></a>',
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'fashion-shop-storefront' ),
				'description' => esc_html__( 'Add the social icon url here.', 'fashion-shop-storefront' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 20
		],
	] );

}
