/* ===============================================
  OPEN CLOSE Menu
============================================= */

function fashion_shop_storefront_open_menu() {
  jQuery('button.menu-toggle').addClass('close-panal');
  setTimeout(function(){
    jQuery('nav#main-menu').show();
  }, 100);

  return false;
}

jQuery( "button.menu-toggle").on("click", fashion_shop_storefront_open_menu);

function fashion_shop_storefront_close_menu() {
  jQuery('button.close-menu').removeClass('close-panal');
  jQuery('nav#main-menu').hide();
}

jQuery( "button.close-menu").on("click", fashion_shop_storefront_close_menu);

/* ===============================================
  TRAP TAB FOCUS ON MODAL MENU
============================================= */

jQuery('button.close-menu').on('keydown', function (e) {

  if (jQuery("this:focus") && !!e.shiftKey && e.keyCode === 9) {
  } else if (jQuery("this:focus") && (e.which === 9)) {
    e.preventDefault();
    jQuery(this).blur();
    jQuery('.nav-menu li a:first').focus()
  }
});

jQuery('.nav-menu li a:first').on('keydown', function (event) {
  if (jQuery("this:focus") && !!event.shiftKey && event.keyCode === 9) {
    event.preventDefault();
    jQuery(this).blur();
    jQuery('button.close-menu').focus()
  }
})

jQuery(document).ready(function() {
  window.addEventListener('load', (event) => {
      jQuery(".loader").delay(2000).fadeOut("slow");
    });
})

/* ===============================================
  Category button
============================================= */
jQuery(document).ready(function(){
  jQuery(".product-cat").hide();
  jQuery("button.product-btn").click(function(){
    jQuery(".product-cat").toggle();
	    });
	});

/* ===============================================
  Scroll Top //
============================================= */

jQuery(window).scroll(function () {
  if (jQuery(this).scrollTop() > 100) {
      jQuery('.scroll-up').fadeIn();
  } else {
      jQuery('.scroll-up').fadeOut();
  }
});

jQuery('a[href="#tobottom"]').click(function () {
  jQuery('html, body').animate({scrollTop: 0}, 'slow');
  return false;
});
(function( $ ) {
  $(window).scroll(function(){
      var sticky = $('.sticky-header'),
      scroll = $(window).scrollTop();

      if (scroll >= 100) sticky.addClass('fixed-header');
      else sticky.removeClass('fixed-header');
    });
  })( jQuery );
(function( $ ) {

$(window).scroll(function(){
    var sticky = $('.sticky-header'),
    scroll = $(window).scrollTop();
    if (scroll >= 100) sticky.addClass('fixed-header');
    else sticky.removeClass('fixed-header');
  });
})( jQuery );

/* ===============================================
  Custom Cursor
============================================= */

const fashion_shop_storefront_customCursor = {
  init: function () {
    this.fashion_shop_storefront_customCursor();
  },
  isVariableDefined: function (el) {
    return typeof el !== "undefined" && el !== null;
  },
  select: function (selectors) {
    return document.querySelector(selectors);
  },
  selectAll: function (selectors) {
    return document.querySelectorAll(selectors);
  },
  fashion_shop_storefront_customCursor: function () {
    const fashion_shop_storefront_cursorDot = this.select(".cursor-point");
    const fashion_shop_storefront_cursorOutline = this.select(".cursor-point-outline");
    if (this.isVariableDefined(fashion_shop_storefront_cursorDot) && this.isVariableDefined(fashion_shop_storefront_cursorOutline)) {
      const cursor = {
        delay: 8,
        _x: 0,
        _y: 0,
        endX: window.innerWidth / 2,
        endY: window.innerHeight / 2,
        cursorVisible: true,
        cursorEnlarged: false,
        $dot: fashion_shop_storefront_cursorDot,
        $outline: fashion_shop_storefront_cursorOutline,

        init: function () {
          this.dotSize = this.$dot.offsetWidth;
          this.outlineSize = this.$outline.offsetWidth;
          this.setupEventListeners();
          this.animateDotOutline();
        },

        updateCursor: function (e) {
          this.cursorVisible = true;
          this.toggleCursorVisibility();
          this.endX = e.clientX;
          this.endY = e.clientY;
          this.$dot.style.top = `${this.endY}px`;
          this.$dot.style.left = `${this.endX}px`;
        },

        setupEventListeners: function () {
          window.addEventListener("load", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          fashion_shop_storefront_customCursor.selectAll("a, button").forEach((el) => {
            el.addEventListener("mouseover", () => {
              this.cursorEnlarged = true;
              this.toggleCursorSize();
            });
            el.addEventListener("mouseout", () => {
              this.cursorEnlarged = false;
              this.toggleCursorSize();
            });
          });

          document.addEventListener("mousedown", () => {
            this.cursorEnlarged = true;
            this.toggleCursorSize();
          });
          document.addEventListener("mouseup", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          document.addEventListener("mousemove", (e) => {
            this.updateCursor(e);
          });

          document.addEventListener("mouseenter", () => {
            this.cursorVisible = true;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          });

          document.addEventListener("mouseleave", () => {
            this.cursorVisible = false;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          });
        },

        animateDotOutline: function () {
          this._x += (this.endX - this._x) / this.delay;
          this._y += (this.endY - this._y) / this.delay;
          this.$outline.style.top = `${this._y}px`;
          this.$outline.style.left = `${this._x}px`;

          requestAnimationFrame(this.animateDotOutline.bind(this));
        },

        toggleCursorSize: function () {
          if (this.cursorEnlarged) {
            this.$dot.style.transform = "translate(-50%, -50%) scale(0.75)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1.6)";
          } else {
            this.$dot.style.transform = "translate(-50%, -50%) scale(1)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1)";
          }
        },

        toggleCursorVisibility: function () {
          if (this.cursorVisible) {
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          } else {
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          }
        },
      };
      cursor.init();
    }
  },
};
fashion_shop_storefront_customCursor.init(); 

/* ===============================================
  Progress Bar
============================================= */
const fashion_shop_storefront_progressBar = {
  init: function () {
      let fashion_shop_storefront_progressBarDiv = document.getElementById("elemento-progress-bar");

      if (fashion_shop_storefront_progressBarDiv) {
          let fashion_shop_storefront_body = document.body;
          let fashion_shop_storefront_rootElement = document.documentElement;

          window.addEventListener("scroll", function (event) {
              let fashion_shop_storefront_winScroll = fashion_shop_storefront_body.scrollTop || fashion_shop_storefront_rootElement.scrollTop;
              let fashion_shop_storefront_height =
              fashion_shop_storefront_rootElement.scrollHeight - fashion_shop_storefront_rootElement.clientHeight;
              let fashion_shop_storefront_scrolled = (fashion_shop_storefront_winScroll / fashion_shop_storefront_height) * 100;
              fashion_shop_storefront_progressBarDiv.style.width = fashion_shop_storefront_scrolled + "%";
          });
      }
  },
};
fashion_shop_storefront_progressBar.init();

/* ===============================================
   sticky copyright
============================================= */

window.addEventListener('scroll', function() {
  var fashion_shop_storefront_footer = document.querySelector('.sticky-copyright');
  if (!fashion_shop_storefront_footer) return; 

  var fashion_shop_storefront_scrollTop = window.scrollY || document.documentElement.fashion_shop_storefront_scrollTop;

  if (fashion_shop_storefront_scrollTop >= 100) {
    fashion_shop_storefront_footer.classList.add('active-sticky');
  }
});

/* ===============================================
   sticky sidebar
============================================= */

window.addEventListener('scroll', function () {
  var fashion_shop_storefront_sidebar = document.querySelector('.sidebar-sticky');
  if (!fashion_shop_storefront_sidebar) return;

  var fashion_shop_storefront_scrollTop = window.scrollY || document.documentElement.scrollTop;
  var fashion_shop_storefront_windowHeight = window.innerHeight;
  var fashion_shop_storefront_documentHeight = document.documentElement.scrollHeight;

  var fashion_shop_storefront_isBottom = fashion_shop_storefront_scrollTop + fashion_shop_storefront_windowHeight >= fashion_shop_storefront_documentHeight - 100;

  if (fashion_shop_storefront_scrollTop >= 100 && !fashion_shop_storefront_isBottom) {
    fashion_shop_storefront_sidebar.classList.add('sidebar-fixed');
  } else {
    fashion_shop_storefront_sidebar.classList.remove('sidebar-fixed');
  }
});