<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'fashion_craze_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function fashion_craze_enqueue_styles() {
        wp_enqueue_style( 'giddy-blog-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'fashion-craze-style', get_stylesheet_directory_uri() . '/style.css', array( 'giddy-blog-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'fashion_craze_enqueue_styles', 99 );

// END ENQUEUE PARENT ACTION
if ( ! function_exists( 'fashion_craze_fonts_url' ) ) :

	function fashion_craze_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lobster, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Lobster font: on or off', 'fashion-craze' ) ) {
		$fonts[] = 'Lobster:300,400,500,600,700';
	}

	/* translators: If there are characters in your language that are not supported by Redressed, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Redressed: on or off', 'fashion-craze' ) ) {
		$fonts[] = 'Redressed';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}
endif;

if ( ! function_exists( 'fashion_craze_get_default_theme_options' ) ) :

    /**
     * Get default theme options.
     *
     * @since 1.0.0
     *
     * @return array Default theme options.
     */
function fashion_craze_get_default_theme_options() {

    $theme_data = wp_get_theme();
    $defaults = array();

	$defaults['show_header_contact_info'] 	= false;
	$defaults['disable_homepage_content_section'] 			= true;
    $defaults['header_email']             	= __( 'info@sensationaltheme.com','fashion-craze' );
    $defaults['header_phone' ]            	= __( '+1-541-754-3010','fashion-craze' );
    $defaults['header_location' ]           = __( 'London, UK','fashion-craze' );
    $defaults['show_header_social_links'] 	= false;
    $defaults['header_social_links']		= array();
    $defaults['disable_header_background_section'] = false;
    $defaults['show_header_search'] 	= true;


    $defaults['header_text_transform_options'] 	= 'none';
    $defaults['header_text_decoration_options'] 	= 'none';
    $defaults['header_font_style_options'] 	= 'none';
    $defaults['header_text_design'] 	= false;

	// Featured Slider Section
	$defaults['disable_featured-slider_section']	= false;
	$defaults['number_of_sr_items']			= 4;
	$defaults['number_of_sr_column']		= 1;
	$defaults['slider_layout_option']			= 'fullwidth-slider';
	$defaults['slider_content_position_option']			= 'default-position';
	$defaults['sr_content_type']			= 'sr_page';
	$defaults['slider_speed']				= 800;
	$defaults['disable_white_overlay']		= true;
	$defaults['slider_arrow_enable']		= true;
	$defaults['slider_fade_enable']		= true;
	$defaults['slider_autoplay_enable']		= true;
	$defaults['slider_infinite_enable']		= true;
	$defaults['slider_title_enable']		= true;
	$defaults['slider_category_enable']		= true;
	$defaults['slider_content_enable']		= true;
	$defaults['slider_posted_on_enable']		= true;
	$defaults['disable_blog_banner_section']		= true;

	// Latest Posts Section

	$defaults['latest_posts_title']	   	 	= esc_html__( 'Outer beauty turns the head, but inner beauty turns the heart.', 'fashion-craze' );
	$defaults['latest_section_posts_title']	   	 	= esc_html__( 'Recent New More Stories', 'fashion-craze' );
	$defaults['number_of_latest_posts_column']	= 3;
	$defaults['pagination_type']		= 'default';
	$defaults['latest_category_enable']		= false;
	$defaults['latest_author_enable']		= true;
	$defaults['latest_comment_enable']		= true;
	$defaults['latest_read_more_text_enable']		= true;
	$defaults['latest_posted_on_enable']		= true;
	$defaults['latest_video_enable']		= false;
	$defaults['blog_layout_content_type']		= 'blog-one';
	$defaults['archive_post_header_title_enable']		= true;
	$defaults['blog_post_header_title_enable']		= true;

	// About Section
	$defaults['disable_about_section']	= false;
	$defaults['number_of_about_items']			= 3;
	$defaults['about_layout_option']			= 'about-two';
	$defaults['about_content_type']			= 'about_post';
	$defaults['about_category_enable']		= true;
	$defaults['about_posted_on_enable']		= true;
	$defaults['about_arrow_enable']		= true;
	$defaults['about_dots_enable']		= true;
	$defaults['about_content_enable']		= true;

	// Single Post Option
	$defaults['single_post_category_enable']		= true;
	$defaults['single_post_posted_on_enable']		= true;
	$defaults['single_post_video_enable']		= true;
	$defaults['single_post_comment_enable']		= true;
	$defaults['single_post_author_enable']		= true;
	$defaults['single_post_pagination_enable']		= true;
	$defaults['single_post_image_enable']		= true;
	$defaults['single_post_header_image_enable']		= true;
	$defaults['single_post_header_title_enable']		= true;
	$defaults['single_post_header_image_as_header_image_enable']		= true;

	// Single Post Option
	$defaults['single_page_video_enable']		= true;
	$defaults['single_page_image_enable']		= true;
	$defaults['single_page_header_image_enable']		= true;
	$defaults['single_page_header_title_enable']		= true;
	$defaults['single_page_header_image_as_header_image_enable']		= true;
	
	$defaults['theme_typography']			=  'default';
	$defaults['body_theme_typography']		=  'default';

	//General Section
	$defaults['latest_readmore_text']				= esc_html__('Read More','fashion-craze');
	$defaults['excerpt_length']				= 50;
	$defaults['layout_options_blog']			= 'no-sidebar';
	$defaults['layout_options_archive']			= 'no-sidebar';
	$defaults['layout_options_page']			= 'no-sidebar';	
	$defaults['layout_options_single']			= 'no-sidebar';	

	//Footer section 
	$defaults['scroll_top_visible']		= true;		
	$defaults['copyright_text']				= esc_html__( 'Copyright &copy; All rights reserved.', 'fashion-craze' );
	$defaults['powered_by_text']			= esc_html__( 'Giddy Blog by Sensational Theme', 'fashion-craze' );


    return $defaults;
}
endif;
add_filter( 'giddy_blog_filter_default_theme_options', 'fashion_craze_get_default_theme_options', 99 );
