<?php
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Farm Adventure Resort
 */

$farm_adventure_resort_classes       = get_theme_mod( 'farm_adventure_resort_classes_setting', false );
$farm_adventure_resort_service_title = get_theme_mod( 'farm_adventure_resort_service_title' );
$farm_adventure_resort_service_text  = get_theme_mod( 'farm_adventure_resort_service_text' );
$farm_adventure_resort_post_count    = absint( get_theme_mod( 'farm_adventure_resort_service_post_count', 0 ) );

if ( $farm_adventure_resort_classes && $farm_adventure_resort_post_count > 0 ) :
?>
<div class="our-services resort-listing">
    <div class="container">   
        <?php if ( $farm_adventure_resort_service_title || $farm_adventure_resort_service_text ) : ?>
            <div class="section-header side-border text-center">
                <?php if ( $farm_adventure_resort_service_title ) : ?>
                    <h3 class="section-title mb-3 service-text">
                        <?php echo esc_html( $farm_adventure_resort_service_title ); ?>
                    </h3>
                <?php endif; ?>

                <?php if ( $farm_adventure_resort_service_text ) : ?>
                    <p class="section-subtitle service-title">
                        <?php echo esc_html( $farm_adventure_resort_service_text ); ?>
                    </p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="row">
            <?php
            for ( $farm_adventure_resort_i = 1; $farm_adventure_resort_i <= $farm_adventure_resort_post_count; $farm_adventure_resort_i++ ) :

                $post_id = absint( get_theme_mod( 'farm_adventure_resort_service_content_post_' . $farm_adventure_resort_i ) );

                if ( ! $post_id ) {
                    continue;
                }

                $post_obj = get_post( $post_id );

                if ( ! $post_obj ) {
                    continue;
                }

                // Additional details from customizer
                $farm_adventure_resort_location      = get_theme_mod( 'farm_adventure_resort_location' . $farm_adventure_resort_i );
                $farm_adventure_resort_time          = get_theme_mod( 'farm_adventure_resort_time' . $farm_adventure_resort_i );
                $farm_adventure_resort_guest         = get_theme_mod( 'farm_adventure_resort_guest' . $farm_adventure_resort_i );
                $farm_adventure_resort_regular_price = get_theme_mod( 'farm_adventure_resort_regular_price' . $farm_adventure_resort_i );
                $farm_adventure_resort_video_link  = get_theme_mod('farm_adventure_resort_video_url' . $farm_adventure_resort_i);
            ?>
            <div class="our-services box col-lg-4 col-md-6 col-12">
              <div class="resort-card border rounded position-relative h-100">                 
                <div class="resort-img mb-3 position-relative">
                    <?php
                    if ( has_post_thumbnail( $post_id ) ) {
                        echo get_the_post_thumbnail( $post_id, 'full', array( 'class' => 'img-fluid' ) );
                    } else {
                        ?>
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/images/slider.png' ); ?>" 
                              alt="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" 
                              class="img-fluid" />
                        <?php
                    }
                    ?>
                </div>
                <div class="resort-card-info p-3">
                  <span class="tag-badge"><?php esc_html_e('Feature', 'farm-adventure-resort'); ?></span>
                  <div class="media-icons">
                      <a href="" target="_blank" rel="noopener">
                        <i class="fa-solid fa-camera"></i>
                      </a>
                    <?php if ($farm_adventure_resort_video_link) : ?>
                        <a href="<?php echo esc_url($farm_adventure_resort_video_link); ?>" target="_blank" rel="noopener">
                            <i class="fa-solid fa-video"></i>
                        </a>
                    <?php endif; ?>
                  </div>
                  <div class="post-reviews">
                      <?php echo do_shortcode( '[kkstarratings]' );?>
                  </div>
                  <h5>
                      <a class="mb-1 resort-card-title" href="<?php echo esc_url( get_permalink( $post_obj->ID ) ); ?>">
                          <?php echo esc_html( get_the_title( $post_obj->ID ) ); ?>
                      </a>
                  </h5>                 
                  <?php if ( $farm_adventure_resort_location ) : ?>
                      <p class="text-muted map-icon small mb-1"><i class="fa-solid fa-location-dot"></i><?php echo esc_html( $farm_adventure_resort_location ); ?></p>
                  <?php endif; ?>
                  <?php if ( $farm_adventure_resort_regular_price ) : ?>
                      <p class="resort-card-price mb-2">
                          <?php echo esc_html( $farm_adventure_resort_regular_price ); ?> 
                          <small class="price-suffix text-muted"><?php esc_html_e(' / Night', 'farm-adventure-resort'); ?></small>
                      </p>
                  <?php endif; ?>
                  <div class="resort-meta d-flex justify-content-between small text-muted">
                      <?php if ( $farm_adventure_resort_time ) : ?>
                          <span class="class-time"><i class="fa-solid fa-clock"></i><?php echo esc_html( $farm_adventure_resort_time ); ?></span>
                      <?php endif; ?>

                      <?php if ( $farm_adventure_resort_guest ) : ?>
                          <span class="class-guest"><i class="fa-solid fa-people-group"></i><?php echo esc_html( $farm_adventure_resort_guest ); ?><span class="price-suffix text-muted"><?php esc_html_e(' Guests', 'farm-adventure-resort'); ?></span></span>
                      <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
            <?php endfor; ?>
        </div>
    </div>
</div>
<?php endif; ?>