<?php
/**
 * Banner Section
 * 
 * @package farm_adventure_resort
 */

 $farm_adventure_resort_slider = get_theme_mod( 'farm_adventure_resort_slider_setting',false );
 $farm_adventure_resort_slider_title = get_theme_mod( 'farm_adventure_resort_slider_title' );
 $farm_adventure_resort_args = array(
   'post_type' => 'post',
   'post_status' => 'publish',
   'category_name' =>  get_theme_mod('farm_adventure_resort_blog_slide_category'),
   'posts_per_page' => 3,
 ); ?>
 
 <?php if ( $farm_adventure_resort_slider ){?>
   <div class="banner">
    <div class="owl-carousel">
      <?php $farm_adventure_resort_arr_posts = new WP_Query( $farm_adventure_resort_args );
      if ( $farm_adventure_resort_arr_posts->have_posts() ) :
        while ( $farm_adventure_resort_arr_posts->have_posts() ) :
          $farm_adventure_resort_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="banner_inner_box">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/slider.png'; ?>">
                </div>
                <?php
              endif;
            ?>
            <div class="banner_box">
            <?php if( !empty($farm_adventure_resort_slider_title) ): ?>
              <div class="section-title">
                  <h4><?php echo esc_html($farm_adventure_resort_slider_title); ?></h4>
              </div>
            <?php endif; ?>
              <h3 class="my-3"><?php the_title(); ?></h3>
              <div class="slide-btns">
                <p class="btn-green">
                  <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Discover More','farm-adventure-resort'); ?><i class="fas fa-angle-right"></i></a>
                </p>              
              </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
   </div>

   <section class="resort-search-bar">
      <div class="container">
        <div class="search-form">
          <?php
            $farm_adventure_resort_page = get_page_by_path('resort-search-results');
            $farm_adventure_resort_url = ($farm_adventure_resort_page && isset($farm_adventure_resort_page->ID))
                ? get_permalink($farm_adventure_resort_page->ID)
                : home_url();
          ?>
          <form method="GET" action="<?php echo esc_url($farm_adventure_resort_url); ?>" class="row align-items-end gx-2" target="_blank">
            <?php if ($farm_adventure_resort_page && isset($farm_adventure_resort_page->ID)) : ?>
              <input type="hidden" name="p" value="<?php echo esc_attr($farm_adventure_resort_page->ID); ?>" />
            <?php endif; ?>

            <div class="col-md-11">
              <div class="form-inner-wrap">
                <div class="row gx-2">
                  
                  <!-- Location -->
                  <div class="col-md-3 position-relative location-icon">
                    <label class="form-label text-uppercase small">
                      <?php echo esc_html(get_theme_mod('farm_adventure_resort_location_label', __('Location', 'farm-adventure-resort'))); ?>
                    </label>
                    <div class="input-icon-wrapper">
                      <input type="text" name="location" class="form-control with-icon" placeholder="Where To Next?" value="<?php echo esc_attr(get_query_var('location')); ?>" />
                      <i class="fa-solid fa-location-dot input-icon"></i>
                    </div>
                  </div>

                  <!-- Check-in -->
                  <div class="col-md-3 checkin">
                    <label class="form-label text-uppercase small">
                      <?php echo esc_html(get_theme_mod('farm_adventure_resort_checkin_label', __('Check In', 'farm-adventure-resort'))); ?>
                    </label>
                    <input type="date" name="checkin" class="form-control" value="<?php echo esc_attr(get_query_var('checkin')); ?>" />
                  </div>

                  <!-- Check-out -->
                  <div class="col-md-3 checkout">
                    <label class="form-label text-uppercase small">
                      <?php echo esc_html(get_theme_mod('farm_adventure_resort_checkout_label', __('Check Out', 'farm-adventure-resort'))); ?>
                    </label>
                    <input type="date" name="checkout" class="form-control" value="<?php echo esc_attr(get_query_var('checkout')); ?>" />
                  </div>

                  <!-- Guests -->
                  <div class="col-md-3 guests-input-wrapper">
                    <label class="form-label text-uppercase small">
                      <?php echo esc_html(get_theme_mod('farm_adventure_resort_guests_label', __('Guests', 'farm-adventure-resort'))); ?>
                    </label>
                    <div class="guests-box">
                      <input type="number" name="guests" class="form-control guests-input" min="0" value="0" readonly />
                      <span class="guest-icon plus"><i class="fas fa-plus"></i></span>
                      <span class="guest-icon minus"><i class="fas fa-minus"></i></span>
                    </div>
                  </div>

                </div>
              </div>
            </div>

            <!-- Search Button -->
            <div class="col-md-1 m-0 p-0 text-end search-button">
              <button type="submit" class="search-btn">
                <i class="fas fa-search"></i>
              </button>
            </div>

          </form>
        </div>
      </div>
    </section>

 <?php } ?>