jQuery(document).ready(function ($) {
	// Initialize banner carousel (e.g., homepage banner)
	$('.banner .owl-carousel').owlCarousel({
	  margin: 20,
	  nav: false,
	  autoplay: true,
	  lazyLoad: true,
	  autoplayTimeout: 3000,
	  loop: false,
	  dots: true,
	  navText: ['<i class="fas fa-chevron-left"></i>', '<i class="fas fa-chevron-right"></i>'],
	  responsive: {
		0: { items: 1 },
		600: { items: 1 },
		1000: { items: 1 }
	  },
	  autoplayHoverPause: true,
	  mouseDrag: true
	});

$('.mobile-nav .toggle-button').on( 'click', function() {
		$('.mobile-nav .main-navigation').slideToggle();
	});

	$('.mobile-nav-wrap .close ').on( 'click', function() {
		$('.mobile-nav .main-navigation').slideToggle();

	});

	$('<button class="submenu-toggle"></button>').insertAfter($('.mobile-nav ul .menu-item-has-children > a'));
	$('.mobile-nav ul li .submenu-toggle').on( 'click', function() {
		$(this).next().slideToggle();
		$(this).toggleClass('open');
	});

	//accessible menu for edge
	 $("#site-navigation ul li a").on( 'focus', function() {
	   $(this).parents("li").addClass("focus");
	}).on( 'blur', function() {
	    $(this).parents("li").removeClass("focus");
	 });

	 //header-search
	jQuery('.search-show').click(function(){
		jQuery('.searchform-inner').css('visibility','visible');
	});

	jQuery('.close').click(function(){
		jQuery('.searchform-inner').css('visibility','hidden');
	});
});

var btn = jQuery('#button');

jQuery(window).scroll(function() {
  if (jQuery(window).scrollTop() > 300) {
    btn.addClass('show');
  } else {
    btn.removeClass('show');
  }
});
btn.on('click', function(e) {
  e.preventDefault();
  jQuery('html, body').animate({scrollTop:0}, '300');
});

window.addEventListener('load', (event) => {
    jQuery(".preloader").delay(1000).fadeOut("slow");
});

jQuery(window).scroll(function() {
    var data_sticky = jQuery(' .head_bg').attr('data-sticky');

    if (data_sticky == 1) {
      if (jQuery(this).scrollTop() > 1){  
        jQuery('.head_bg').addClass("sticky-head");
      } else {
        jQuery('.head_bg').removeClass("sticky-head");
      }
    }
});

function farm_adventure_resort_preloderFunction() {
    setTimeout(function() {           
        document.getElementById("page-top").scrollIntoView();
        
        $('#ctn-preloader').addClass('loaded');  
        // Once the preloader has finished, the scroll appears 
        $('body').removeClass('no-scroll-y');

        if ($('#ctn-preloader').hasClass('loaded')) {
            // It is so that once the preloader is gone, the entire preloader section will removed
            $('#preloader').delay(1000).queue(function() {
                $(this).remove();
                
                // If you want to do something after removing preloader:
                farm_adventure_resort_afterLoad();
                
            });
        }
    }, 3000);
}
function farm_adventure_resort_afterLoad() {
    // After Load function body!
}

document.addEventListener('DOMContentLoaded', function () {
	const farm_adventure_resort_minusBtn = document.querySelector('.guest-icon.minus');
	const farm_adventure_resort_plusBtn = document.querySelector('.guest-icon.plus');
	const farm_adventure_resort_input = document.querySelector('.guests-input');

	if (!farm_adventure_resort_minusBtn || !farm_adventure_resort_plusBtn || !farm_adventure_resort_input) return;

	farm_adventure_resort_minusBtn.addEventListener('click', () => {
		let currentValue = parseInt(farm_adventure_resort_input.value) || 0;
		if (currentValue > 0) farm_adventure_resort_input.value = currentValue - 1;
	});

	farm_adventure_resort_plusBtn.addEventListener('click', () => {
		let currentValue = parseInt(farm_adventure_resort_input.value) || 0;
		farm_adventure_resort_input.value = currentValue + 1;
	});
});