<?php
/**
 * Right Buttons Panel.
 *
 * @package farm_adventure_resort
 */
?>
<div class="panel-right">
	<div class="panel-aside">
		<h4 class="heading"><?php esc_html_e( 'Upgrade To Pro Version', 'farm-adventure-resort' ); ?></h4>
		<p class="panel-info">
			<?php
			echo wp_kses_post(
				__( 'Get Extra <span class="off">30% OFF</span>, Use Code <span class="code">“NY2026”</span> at the time of Checkout', 'farm-adventure-resort' )
			);
			?>
		</p>
		<div class="pro-img">
			<img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/images/getstart-img.png'; ?>" alt="<?php echo esc_attr( 'screenshot', 'farm-adventure-resort'); ?>"/>
		</div>
		<a class="button button-primary first-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_URL ); ?>" title="<?php esc_attr_e( 'View Premium Version', 'farm-adventure-resort' ); ?>" target="_blank">
            <?php esc_html_e( 'Upgrade To Pro With Just $40', 'farm-adventure-resort' ); ?>
        </a>
	</div>
	<div>
		<h4><?php esc_html_e( 'ABOUT THEME', 'farm-adventure-resort' ); ?></h4>
		<p><?php esc_html_e( 'The Pro version of our theme offers a seamless website customization experience with its intuitive interface. With just a few clicks, you can effortlessly transform the look and feel of your website. Enjoy the freedom to personalize various elements such as colors, background images, patterns, and fonts, elevating your website s aesthetics and brand identity. In addition, the Pro theme goes beyond the basic features of the free version by providing an expanded selection of homepage sections. This enables you to effectively showcase your organizations services and offerings, empowering the growth of your business or cause. Moreover, the Pro version includes a wide range of professionally designed page templates, giving you a head start in creating impactful web pages with ease. To ensure a top-notch experience, the Pro version receives regular updates, ensuring compatibility with the latest web technologies and maintaining optimal performance. Additionally, our dedicated support team is readily available to address any questions or concerns you may have, providing timely assistance when you need it most.', 'farm-adventure-resort' ); ?></p>
	</div>
</div>