<?php
/**
 * Help Panel.
 *
 * @package farm_adventure_resort
 */

$farm_adventure_resort_import_done = get_option( 'farm_adventure_resort_demo_import_done' );
$farm_adventure_resort_button_text = $farm_adventure_resort_import_done
	? __( 'View Site', 'farm-adventure-resort' )
	: __( 'Start Demo Import', 'farm-adventure-resort' );
$farm_adventure_resort_button_link = $farm_adventure_resort_import_done
	? home_url( '/' )
	: admin_url( 'themes.php?page=farmadventureresort-wizard' );
?>
<div id="help-panel" class="panel-left visible">
    <div class="panel-aside active">
        <div class="demo-content">
            <div class="demo-info">
                <h4><?php esc_html_e( 'DEMO CONTENT IMPORTER', 'farm-adventure-resort' ); ?></h4>
                <p><?php esc_html_e('The Demo Content Importer helps you quickly set up your website to look exactly like the theme demo. Instead of building pages from scratch, you can import pre-designed layouts, pages, menus, images, and basic settings in just a few clicks.','farm-adventure-resort'); ?></p>
                <a class="button button-primary first-color" style="text-transform: capitalize" href="<?php echo esc_url( $farm_adventure_resort_button_link ); ?>" title="<?php echo esc_attr( $farm_adventure_resort_button_text ); ?>"
                    <?php echo $farm_adventure_resort_import_done ? 'target="_blank"' : ''; ?>>
                    <?php echo esc_html( $farm_adventure_resort_button_text ); ?>
                </a>
            </div>
            <div class="demo-img">
                <img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" alt="<?php echo esc_attr( 'screenshot', 'farm-adventure-resort'); ?>"/>
            </div>
        </div>
    </div>

    <div class="panel-aside" >
        <h4><?php esc_html_e( 'USEFUL LINKS', 'farm-adventure-resort' ); ?></h4>
        <p><?php esc_html_e( 'Find everything you need to set up, customize, and manage your website with ease. These helpful resources are designed to guide you at every step, from installation to advanced customization.', 'farm-adventure-resort' ); ?></p>
        <div class="useful-links">
            <a class="button button-primary second-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_DEMO_URL ); ?>" title="<?php esc_attr_e( 'Live Demo', 'farm-adventure-resort' ); ?>" target="_blank">
                <?php esc_html_e( 'Live Demo', 'farm-adventure-resort' ); ?>
            </a>
            <a class="button button-primary first-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_FREE_DOC_URL ); ?>" title="<?php esc_attr_e( 'Documentation', 'farm-adventure-resort' ); ?>" target="_blank">
                <?php esc_html_e( 'Documentation', 'farm-adventure-resort' ); ?>
            </a>
            <a class="button button-primary second-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_URL ); ?>" title="<?php esc_attr_e( 'Get Premium', 'farm-adventure-resort' ); ?>" target="_blank">
                <?php esc_html_e( 'Get Premium', 'farm-adventure-resort' ); ?>
            </a>
            <a class="button button-primary first-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_BUNDLE_URL ); ?>" title="<?php esc_attr_e( 'Get Bundle - 60+ Themes', 'farm-adventure-resort' ); ?>" target="_blank">
                <?php esc_html_e( 'Get Bundle - 60+ Themes', 'farm-adventure-resort' ); ?>
            </a>
        </div>
    </div>

    <div class="panel-aside" >
        <h4><?php esc_html_e( 'REVIEW', 'farm-adventure-resort' ); ?></h4>
        <p><?php esc_html_e( 'If you have a moment, please consider leaving a rating and short review. It only takes a minute, and your support means a lot to us.', 'farm-adventure-resort' ); ?></p>
        <a class="button button-primary first-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_REVIEW_URL ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'farm-adventure-resort' ); ?>" target="_blank">
            <?php esc_html_e( 'Leave a Review', 'farm-adventure-resort' ); ?>
        </a>
    </div>
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'CONTACT SUPPORT', 'farm-adventure-resort' ); ?></h4>
        <p>
            <?php esc_html_e( 'Thank you for choosing Farm Adventure Resort! We appreciate your interest in our theme and are here to assist you with any support you may need.', 'farm-adventure-resort' ); ?></p>
        <a class="button button-primary first-color" href="<?php echo esc_url( FARM_ADVENTURE_RESORT_SUPPORT_URL ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'farm-adventure-resort' ); ?>" target="_blank">
            <?php esc_html_e( 'Contact Support', 'farm-adventure-resort' ); ?>
        </a>
    </div>
</div>