<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package farm_adventure_resort
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function farm_adventure_resort_body_classes( $classes ) {
  global $farm_adventure_resort_post;
  
    if( !is_page_template( 'template-home.php' ) ){
        $classes[] = 'inner';
        // Adds a class of group-blog to blogs with more than 1 published author.
    }

    if ( is_multi_author() ) {
        $classes[] = 'group-blog ';
    }

    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }
    

    if( farm_adventure_resort_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }    

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_page() ) {
        $classes[] = 'hfeed ';
    }
  
    if( is_404() ||  is_search() ){
        $classes[] = 'full-width';
    }
  
    if( ! is_active_sidebar( 'right-sidebar' ) ) {
        $classes[] = 'full-width'; 
    }

    return $classes;
}
add_filter( 'body_class', 'farm_adventure_resort_body_classes' );

 /**
 * 
 * @link http://www.altafweb.com/2011/12/remove-specific-tag-from-php-string.html
 */
function farm_adventure_resort_strip_single( $tag, $string ){
    $string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
    $string=preg_replace('/<\/'.$tag.'>/i', '', $string);
    return $string;
}

if ( ! function_exists( 'farm_adventure_resort_excerpt_more' ) ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function farm_adventure_resort_excerpt_more($more) {
  return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'farm_adventure_resort_excerpt_more' );


if( ! function_exists( 'farm_adventure_resort_footer_credit' ) ):
    /**
     * Footer Credits
    */
    function farm_adventure_resort_footer_credit() {
        $farm_adventure_resort_copyright_text = get_theme_mod('farm_adventure_resort_footer_copyright_text');
    
        $farm_adventure_resort_text = '<div class="site-info"><div class="container"><span class="copyright">';
        if ($farm_adventure_resort_copyright_text) {
            $farm_adventure_resort_text .= wp_kses_post($farm_adventure_resort_copyright_text); 
        } else {
            $farm_adventure_resort_text .= esc_html__('&copy; ', 'farm-adventure-resort') . date_i18n(esc_html__('Y', 'farm-adventure-resort')); 
            $farm_adventure_resort_text .= ' <a href="' . esc_url(home_url('/')) . '">' . esc_html(get_bloginfo('name')) . '</a>' . esc_html__('. All Rights Reserved.', 'farm-adventure-resort');
        }
        $farm_adventure_resort_text .= '</span>';
        $farm_adventure_resort_text .= '<span class="by"> <a href="' . esc_url('https://www.themeignite.com/products/farm-adventure-resort') . '" rel="nofollow" target="_blank">' . FARM_ADVENTURE_RESORT_THEME_NAME . '</a>' . esc_html__(' By ', 'farm-adventure-resort') . '<a href="' . esc_url('https://themeignite.com/') . '" rel="nofollow" target="_blank">' . esc_html__('Themeignite', 'farm-adventure-resort') . '</a>.';
        /* translators: %s: link to WordPress.org */
        $farm_adventure_resort_text .= sprintf(esc_html__(' Powered By %s', 'farm-adventure-resort'), '<a href="' . esc_url(__('https://wordpress.org/', 'farm-adventure-resort')) . '" target="_blank">WordPress</a>.');
        if (function_exists('the_privacy_policy_link')) {
            $farm_adventure_resort_text .= get_the_privacy_policy_link();
        }
        $farm_adventure_resort_text .= '</span></div></div>';
        echo apply_filters('farm_adventure_resort_footer_text', $farm_adventure_resort_text);
    }
    add_action('farm_adventure_resort_footer', 'farm_adventure_resort_footer_credit');
    endif;

/**
 * Is Woocommerce activated
*/
if ( ! function_exists( 'farm_adventure_resort_woocommerce_activated' ) ) {
  function farm_adventure_resort_woocommerce_activated() {
    if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
  }
}

if( ! function_exists( 'farm_adventure_resort_change_comment_form_default_fields' ) ) :
/**
 * Change Comment form default fields i.e. author, email & url.
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function farm_adventure_resort_change_comment_form_default_fields( $fields ){    
    // get the current commenter if available
    $farm_adventure_resort_commenter = wp_get_current_commenter();
 
    // core functionality
    $req      = get_option( 'require_name_email' );
    $farm_adventure_resort_aria_req = ( $req ? " aria-required='true'" : '' );
    $farm_adventure_resort_required = ( $req ? " required" : '' );
    $farm_adventure_resort_author   = ( $req ? __( 'Name*', 'farm-adventure-resort' ) : __( 'Name', 'farm-adventure-resort' ) );
    $farm_adventure_resort_email    = ( $req ? __( 'Email*', 'farm-adventure-resort' ) : __( 'Email', 'farm-adventure-resort' ) );
 
    // Change just the author field
    $fields['author'] = '<p class="comment-form-author"><label class="screen-reader-text" for="author">' . esc_html__( 'Name', 'farm-adventure-resort' ) . '<span class="required">*</span></label><input id="author" name="author" placeholder="' . esc_attr( $farm_adventure_resort_author ) . '" type="text" value="' . esc_attr( $farm_adventure_resort_commenter['comment_author'] ) . '" size="30"' . $farm_adventure_resort_aria_req . $farm_adventure_resort_required . ' /></p>';
    
    $fields['email'] = '<p class="comment-form-email"><label class="screen-reader-text" for="email">' . esc_html__( 'Email', 'farm-adventure-resort' ) . '<span class="required">*</span></label><input id="email" name="email" placeholder="' . esc_attr( $farm_adventure_resort_email ) . '" type="text" value="' . esc_attr(  $farm_adventure_resort_commenter['comment_author_email'] ) . '" size="30"' . $farm_adventure_resort_aria_req . $farm_adventure_resort_required. ' /></p>';
    
    $fields['url'] = '<p class="comment-form-url"><label class="screen-reader-text" for="url">' . esc_html__( 'Website', 'farm-adventure-resort' ) . '</label><input id="url" name="url" placeholder="' . esc_attr__( 'Website', 'farm-adventure-resort' ) . '" type="text" value="' . esc_attr( $farm_adventure_resort_commenter['comment_author_url'] ) . '" size="30" /></p>'; 
    
    return $fields;    
}
endif;
add_filter( 'comment_form_default_fields', 'farm_adventure_resort_change_comment_form_default_fields' );

if( ! function_exists( 'farm_adventure_resort_change_comment_form_defaults' ) ) :
/**
 * Change Comment Form defaults
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function farm_adventure_resort_change_comment_form_defaults( $defaults ){    
    $defaults['comment_field'] = '<p class="comment-form-comment"><label class="screen-reader-text" for="comment">' . esc_html__( 'Comment', 'farm-adventure-resort' ) . '</label><textarea id="comment" name="comment" placeholder="' . esc_attr__( 'Comment', 'farm-adventure-resort' ) . '" cols="45" rows="8" aria-required="true" required></textarea></p>';
    
    return $defaults;    
}
endif;
add_filter( 'comment_form_defaults', 'farm_adventure_resort_change_comment_form_defaults' );

if( ! function_exists( 'farm_adventure_resort_escape_text_tags' ) ) :
/**
 * Remove new line tags from string
 *
 * @param $text
 * @return string
 */
function farm_adventure_resort_escape_text_tags( $text ) {
    return (string) str_replace( array( "\r", "\n" ), '', strip_tags( $text ) );
}
endif;

if( ! function_exists( 'wp_body_open' ) ) :
/**
 * Fire the wp_body_open action.
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
*/
function wp_body_open() {
    /**
     * Triggered after the opening <body> tag.
    */
    do_action( 'wp_body_open' );
}
endif;

if ( ! function_exists( 'farm_adventure_resort_get_fallback_svg' ) ) :    
/**
 * Get Fallback SVG
*/
function farm_adventure_resort_get_fallback_svg( $farm_adventure_resort_post_thumbnail ) {
    if( ! $farm_adventure_resort_post_thumbnail ){
        return;
    }
    
    $farm_adventure_resort_image_size = farm_adventure_resort_get_image_sizes( $farm_adventure_resort_post_thumbnail );
     
    if( $farm_adventure_resort_image_size ){ ?>
        <div class="svg-holder">
             <svg class="fallback-svg" viewBox="0 0 <?php echo esc_attr( $farm_adventure_resort_image_size['width'] ); ?> <?php echo esc_attr( $farm_adventure_resort_image_size['height'] ); ?>" preserveAspectRatio="none">
                    <rect width="<?php echo esc_attr( $farm_adventure_resort_image_size['width'] ); ?>" height="<?php echo esc_attr( $farm_adventure_resort_image_size['height'] ); ?>" style="fill:#dedddd;"></rect>
            </svg>
        </div>
        <?php
    }
}
endif;

function farm_adventure_resort_enqueue_google_fonts() {

    require get_template_directory() . '/inc/wptt-webfont-loader.php';

    wp_enqueue_style(
        'google-fonts-satisfy',
        farm_adventure_resort_wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Satisfy&display=swap' ),
        array(),
        '1.0'
    );

    wp_enqueue_style(
        'google-fonts-manrope',
        farm_adventure_resort_wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&display=swap' ),
        array(),
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'farm_adventure_resort_enqueue_google_fonts' );


if( ! function_exists( 'farm_adventure_resort_site_branding' ) ) :
/**
 * Site Branding
*/
function farm_adventure_resort_site_branding(){
    $farm_adventure_resort_logo_site_title = get_theme_mod( 'header_site_title', false );
    $farm_adventure_resort_tagline = get_theme_mod( 'header_tagline', false );
    $farm_adventure_resort_logo_width = get_theme_mod('logo_width', 100); // Retrieve the logo width setting

    ?>
    <div class="site-branding" style="max-width: <?php echo esc_attr(get_theme_mod('logo_width', '-1'))?>px;">
        <?php 
        // Check if custom logo is set and display it
        if (function_exists('has_custom_logo') && has_custom_logo()) {
            the_custom_logo();
        }
        if ($farm_adventure_resort_logo_site_title):
             if (is_front_page()): ?>
            <h1 class="site-title" style="font-size: <?php echo esc_attr(get_theme_mod('farm_adventure_resort_site_title_size', '25')); ?>px;">
            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
          </h1>
            <?php else: ?>
                <p class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </p>
            <?php endif; ?>
        <?php endif; 
    
        if ($farm_adventure_resort_tagline) :
            $farm_adventure_resort_description = get_bloginfo('description', 'display');
            if ($farm_adventure_resort_description || is_customize_preview()) :
        ?>
                <p class="site-description" itemprop="description"><?php echo $farm_adventure_resort_description; ?></p>
            <?php endif;
        endif;
        ?>
    </div> 
    <?php
}
endif;
if( ! function_exists( 'farm_adventure_resort_navigation' ) ) :
    /**
     * Site Navigation
    */
    function farm_adventure_resort_navigation(){
        ?>
        <nav class="main-navigation" id="site-navigation" role="navigation">
            <?php 
            wp_nav_menu( array( 
                'theme_location' => 'primary', 
                'menu_id' => 'primary-menu' 
            ) ); 
            ?>
        </nav>
        <?php
    }
endif;

if ( ! function_exists( 'farm_adventure_resort_header_info' ) ) :
    function farm_adventure_resort_header_info() {
        $farm_adventure_resort_phone = get_theme_mod( 'farm_adventure_resort_header_phone' );
        $farm_adventure_resort_email = get_theme_mod( 'farm_adventure_resort_header_email' );
        $farm_adventure_resort_header_btn_text     = get_theme_mod( 'farm_adventure_resort_header_btn_text' );
        $farm_adventure_resort_header_btn_url     = get_theme_mod( 'farm_adventure_resort_header_btn_url' );
        ?>
        <div class="header_info row align-items-center">
            <?php if ( $farm_adventure_resort_phone || $farm_adventure_resort_email || $farm_adventure_resort_header_btn_text ) : ?>

                <!-- Left Column: Search + Cart -->
                <div class="col-lg-2 col-md-2 col-sm-2 col-12 d-flex gap-3 align-items-center header-left-info">
                    <?php if ( get_theme_mod('farm_adventure_resort_show_hide_search', false) != '' ) : ?>
                        <div class="search-body text-center text-md-center">
                            <button type="button" class="search-show">
                                <i class="<?php echo esc_attr(get_theme_mod('farm_adventure_resort_search_icon','fas fa-search')); ?>"></i>
                            </button>
                        </div>
                        <div class="searchform-inner">
                            <?php get_search_form(); ?>
                            <button type="button" class="close" aria-label="<?php esc_attr_e('Close', 'farm-adventure-resort'); ?>">
                                <span aria-hidden="true">X</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if ( class_exists( 'WooCommerce' ) ) : ?>
                        <a class="cart-customlocation" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e('View Shopping Cart', 'farm-adventure-resort'); ?>">
                            <i class="fas fa-shopping-cart me-1"></i>
                        </a>
                    <?php endif; ?>
                </div>

                <!-- Right Column: Contact Info + Header Button -->
                <div class="col-lg-10 col-md-10 col-sm-10 col-12 d-flex align-items-center header-right-info justify-content-end">
                    <?php if ( $farm_adventure_resort_phone || $farm_adventure_resort_email ) : ?>
                        <div class="contact-info d-flex align-items-center gap-2 p-2">
                            <span class="icon phone">
                                <i class="<?php echo esc_attr(get_theme_mod('farm_adventure_resort_phone_icon', 'fas fa-phone')); ?>"></i>
                            </span>
                            <div class="contact-details d-flex flex-column text-start">
                                <?php if ( $farm_adventure_resort_phone ) : ?>
                                    <a href="tel:<?php echo esc_attr($farm_adventure_resort_phone); ?>" class="phone">
                                        <?php echo esc_html($farm_adventure_resort_phone); ?>
                                    </a>
                                <?php endif; ?>
                                <?php if ( $farm_adventure_resort_email ) : ?>
                                    <a href="mailto:<?php echo esc_attr($farm_adventure_resort_email); ?>" class="mail">
                                        <?php echo esc_html($farm_adventure_resort_email); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ( $farm_adventure_resort_header_btn_text ) : ?>
                        <div class="menudiv-button text-lg-start text-md-start py-2">
                            <a href="<?php echo esc_url($farm_adventure_resort_header_btn_url); ?>" class="text-white">
                                <?php echo esc_html($farm_adventure_resort_header_btn_text); ?>
                                <i class="fas fa-angle-right"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>

            <?php endif; ?>
        </div>
        <?php
    }
endif;

if( ! function_exists( 'farm_adventure_resort_header' ) ) :
    /**
     * Header Start
    */
    function farm_adventure_resort_header(){
        $farm_adventure_resort_header_image = get_header_image();
        $farm_adventure_resort_sticky_header = get_theme_mod('farm_adventure_resort_sticky_header');
        $farm_adventure_resort_phone        = get_theme_mod( 'farm_adventure_resort_header_phone' );
        $farm_adventure_resort_email        = get_theme_mod( 'farm_adventure_resort_header_email' );
        ?>
        <div id="page-site-header" class="main-header">
            <header id="masthead" style="background-image: url('<?php echo esc_url( $farm_adventure_resort_header_image ); ?>');" class="site-header header-inner" role="banner">      
                <div class="theme-menu head_bg" style="background-image: url('<?php echo esc_url( $farm_adventure_resort_header_image ); ?>');" data-sticky="<?php echo $farm_adventure_resort_sticky_header; ?>">
                    <div class="head-section">
                        <div class="row g-0">
                        <div class="col-xl-2 col-lg-2 col-md-12 col-sm-12 col-12 site-brand">
                            <?php farm_adventure_resort_site_branding(); ?> 
                        </div>
                        <div class="col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12 align-self-center">
                            <?php farm_adventure_resort_navigation(); ?>
                        </div>
                        <div class="col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12 align-self-center">
                            <?php farm_adventure_resort_header_info(); ?>
                        </div>
                    </div>
                    </div>
                </div>                 
            </header>
        </div>
        <?php
    }
endif;
add_action( 'farm_adventure_resort_header', 'farm_adventure_resort_header', 20 );
