<?php
/**
 * Farm Adventure Resort Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package farm_adventure_resort
 */

if( ! function_exists( 'farm_adventure_resort_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function farm_adventure_resort_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');

    //Register the sortable control type.
    $wp_customize->register_control_type( 'Farm_Adventure_Resort_Control_Sortable' ); 

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'farm-adventure-resort' );
    }
	
    /* Option list of all post */	
    $farm_adventure_resort_options_posts = array();
    $farm_adventure_resort_options_posts_obj = get_posts('posts_per_page=-1');
    $farm_adventure_resort_options_posts[''] = esc_html__( 'Choose Post', 'farm-adventure-resort' );
    foreach ( $farm_adventure_resort_options_posts_obj as $farm_adventure_resort_posts ) {
    	$farm_adventure_resort_options_posts[$farm_adventure_resort_posts->ID] = $farm_adventure_resort_posts->post_title;
    }
    
    /* Option list of all categories */
    $farm_adventure_resort_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $farm_adventure_resort_option_categories = array();
    $farm_adventure_resort_category_lists = get_categories( $farm_adventure_resort_args );
    $farm_adventure_resort_option_categories[''] = esc_html__( 'Choose Category', 'farm-adventure-resort' );
    foreach( $farm_adventure_resort_category_lists as $farm_adventure_resort_category ){
        $farm_adventure_resort_option_categories[$farm_adventure_resort_category->term_id] = $farm_adventure_resort_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'farm-adventure-resort' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'farm-adventure-resort' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'farm-adventure-resort' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'farm-adventure-resort' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'farm-adventure-resort'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'farm_adventure_resort_site_title_size', array(
        'default'           => 25, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'farm_adventure_resort_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'farm-adventure-resort' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Responsive Media settings */
    
    $wp_customize->add_section(
        'farm_adventure_resort_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'farm-adventure-resort' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    //Global Color
    $wp_customize->add_section(
        'farm_adventure_resort_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'farm-adventure-resort' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_general_settings',
        )
    );

    $wp_customize->add_setting('farm_adventure_resort_primary_color', array(
        'default'           => '#63AC45',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'farm_adventure_resort_primary_color', array(
        'label'    => __('Theme Primary Color', 'farm-adventure-resort'),
        'section'  => 'farm_adventure_resort_global_color',
        'settings' => 'farm_adventure_resort_primary_color',
    )));    

    $wp_customize->add_setting('farm_adventure_resort_secondary_color', array(
        'default'           => '#F7921E',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'farm_adventure_resort_secondary_color', array(
        'label'    => __('Theme Secondary Color', 'farm-adventure-resort'),
        'section'  => 'farm_adventure_resort_global_color',
        'settings' => 'farm_adventure_resort_secondary_color',
    )));  

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'farm_adventure_resort_post_settings',
         array(
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'farm-adventure-resort' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'farm-adventure-resort' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'farm_adventure_resort_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'farm-adventure-resort' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_post_settings',
        )
    );

    $wp_customize->add_setting('farm_adventure_resort_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_post_layout',
    ));

    $wp_customize->add_control('farm_adventure_resort_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'farm-adventure-resort'),
        'section'  => 'farm_adventure_resort_post_layout_section',
        'settings' => 'farm_adventure_resort_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'farm-adventure-resort'),
            'right-sidebar'   => __('Right Sidebar', 'farm-adventure-resort'),
            'left-sidebar'   => __('Left Sidebar', 'farm-adventure-resort'),
            'three-column'   => __('Three Columns', 'farm-adventure-resort'),
            'four-column'   => __('Four Columns', 'farm-adventure-resort'),
        ),
    ));

    $wp_customize->add_setting('farm_adventure_resort_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('farm_adventure_resort_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','farm-adventure-resort'),
        'section' => 'farm_adventure_resort_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','farm-adventure-resort'),
            'center-align' => __('Center Alignment','farm-adventure-resort'),
            'left-align' => __('Left Alignment','farm-adventure-resort'),
        ),
    ) );

     /** Post Layouts Ends */
     
    /** Post Settings */
    $wp_customize->add_section(
        'farm_adventure_resort_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'farm-adventure-resort' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'farm_adventure_resort_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'farm_adventure_resort_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'farm_adventure_resort_post_settings', 
        'label'       => __( 'Display Read More Button', 'farm-adventure-resort' ),
    ) );

    $wp_customize->add_setting('farm_adventure_resort_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'farm_adventure_resort_sanitize_sortable',
    ));
    $wp_customize->add_control(new Farm_Adventure_Resort_Control_Sortable($wp_customize, 'farm_adventure_resort_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'farm-adventure-resort'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'farm-adventure-resort') ,
        'section' => 'farm_adventure_resort_post_settings',
        'choices' => array(
            'heading' => __('heading', 'farm-adventure-resort') ,
            'author' => __('author', 'farm-adventure-resort') ,
            'featured-image' => __('featured-image', 'farm-adventure-resort') ,
            'content' => __('content', 'farm-adventure-resort') ,
            'button' => __('button', 'farm-adventure-resort') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'farm_adventure_resort_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'farm-adventure-resort' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('farm_adventure_resort_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'farm-adventure-resort'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'farm_adventure_resort_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'farm-adventure-resort'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('farm_adventure_resort_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_choicess',
    ));
    $wp_customize->add_control('farm_adventure_resort_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'farm-adventure-resort'),
        'section' => 'farm_adventure_resort_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('farm_adventure_resort_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_choicess',
    ));
    $wp_customize->add_control('farm_adventure_resort_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'farm-adventure-resort'),
        'section' => 'farm_adventure_resort_typography_settings',
    ));

    /** Typography Settings Section End */

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'farm_adventure_resort_general_settings',
         array(
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'farm-adventure-resort' ),
            'description' => esc_html__( 'Customize General Settings', 'farm-adventure-resort' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'farm_adventure_resort_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'farm-adventure-resort' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_general_settings',
            'type'        => 'checkbox',
        )
    );

    /** Header Section Settings */
    $wp_customize->add_section(
        'farm_adventure_resort_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'farm-adventure-resort' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_home_page_settings',
        )
    );

    /** Phone */
    $wp_customize->add_setting(
        'farm_adventure_resort_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'farm_adventure_resort_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'farm-adventure-resort' ),
            'section' => 'farm_adventure_resort_header_section_settings',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting('farm_adventure_resort_phone_icon',array(
        'default'   => 'fas fa-phone',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Farm_Adventure_Resort_Changeable_Icon(
        $wp_customize,'farm_adventure_resort_phone_icon',array(
        'label' => __('Phone Icon','farm-adventure-resort'),
        'transport' => 'refresh',
        'section'   => 'farm_adventure_resort_header_section_settings',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('farm_adventure_resort_phone_icon',array(
        'default'   => 'fas fa-phone',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Farm_Adventure_Resort_Changeable_Icon(
        $wp_customize,'farm_adventure_resort_phone_icon',array(
        'label' => __('Phone Icon','farm-adventure-resort'),
        'transport' => 'refresh',
        'section'   => 'farm_adventure_resort_header_section_settings',
        'type'      => 'icon'
    )));

     /** Email */
    $wp_customize->add_setting(
        'farm_adventure_resort_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );

    $wp_customize->add_control(
        'farm_adventure_resort_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'farm-adventure-resort' ),
            'section' => 'farm_adventure_resort_header_section_settings',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting( 
        'farm_adventure_resort_show_hide_search', 
        array(
            'default' => false ,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_show_hide_search',
        array(
            'label'       => __( 'Show Search Icon', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_header_section_settings',
            'type'        => 'checkbox',
        )
    );
    $wp_customize->add_setting('farm_adventure_resort_search_icon',array(
        'default'   => 'fas fa-search',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Farm_Adventure_Resort_Changeable_Icon(
        $wp_customize,'farm_adventure_resort_search_icon',array(
        'label' => __('Search Icon','farm-adventure-resort'),
        'transport' => 'refresh',
        'section'   => 'farm_adventure_resort_header_section_settings',
        'type'      => 'icon'
    )));

    /** Booking Button */
    $wp_customize->add_setting(
        'farm_adventure_resort_header_btn_text',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'farm_adventure_resort_header_btn_text',
        array(
            'label' => esc_html__( 'Add Button Text', 'farm-adventure-resort' ),
            'section' => 'farm_adventure_resort_header_section_settings',
            'type' => 'text',
        )
    );

    /** Header Button */
    $wp_customize->add_setting(
        'farm_adventure_resort_header_btn_url',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'farm_adventure_resort_header_btn_url',
        array(
            'label' => esc_html__( 'Add Button URL', 'farm-adventure-resort' ),
            'section' => 'farm_adventure_resort_header_section_settings',
            'type' => 'url',
        )
    );

   /** Sticky Header control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'farm_adventure_resort_menu_font_weight', array(
        'default'           => 'Medium',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'farm_adventure_resort_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'farm-adventure-resort' ),
        'section'  => 'farm_adventure_resort_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'farm-adventure-resort' ),
            '200' => __( '200 - Extra Light', 'farm-adventure-resort' ),
            '300' => __( '300 - Light', 'farm-adventure-resort' ),
            '400' => __( '400 - Normal', 'farm-adventure-resort' ),
            '500' => __( '500 - Medium', 'farm-adventure-resort' ),
            '600' => __( '600 - Semi Bold', 'farm-adventure-resort' ),
            '700' => __( '700 - Bold', 'farm-adventure-resort' ),
            '800' => __( '800 - Extra Bold', 'farm-adventure-resort' ),
            '900' => __( '900 - Black', 'farm-adventure-resort' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'farm_adventure_resort_menu_text_transform', array(
        'default'           => 'Capitalize',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'farm_adventure_resort_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'farm-adventure-resort' ),
        'section'  => 'farm_adventure_resort_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'farm-adventure-resort' ),
            'capitalize' => __( 'Capitalize', 'farm-adventure-resort' ),
            'uppercase'  => __( 'Uppercase', 'farm-adventure-resort' ),
            'lowercase'  => __( 'Lowercase', 'farm-adventure-resort' ),
        ),
    ) );

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'farm_adventure_resort_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'farm-adventure-resort' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'farm-adventure-resort' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'farm_adventure_resort_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'farm-adventure-resort' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_slider_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'farm_adventure_resort_slider_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'farm_adventure_resort_slider_title', 
        array(
            'label'       => __('Slider Title', 'farm-adventure-resort'),
            'section'     => 'farm_adventure_resort_slider_section_settings',
            'settings'    => 'farm_adventure_resort_slider_title',
            'type'        => 'text'
        )
    );

    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'farm_adventure_resort_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'farm_adventure_resort_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'farm_adventure_resort_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Latest Post','farm-adventure-resort'),
            'section' => 'farm_adventure_resort_slider_section_settings',
        )
    );

    /** Service Section Start */

    $wp_customize->add_section(
        'farm_adventure_resort_classes_section_settings',
        array(
            'title' => esc_html__( 'Services Section Settings', 'farm-adventure-resort' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'farm_adventure_resort_home_page_settings',
        )
    );

    $wp_customize->add_setting( 
        'farm_adventure_resort_classes_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_classes_setting',
        array(
            'label'       => __( 'Show Services Section', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_classes_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'farm_adventure_resort_service_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'farm_adventure_resort_service_title', 
        array(
            'label'       => __('Section Title', 'farm-adventure-resort'),
            'section'     => 'farm_adventure_resort_classes_section_settings',
            'settings'    => 'farm_adventure_resort_service_title',
            'type'        => 'text'
        )
    );

     // Section Text
    $wp_customize->add_setting(
        'farm_adventure_resort_service_text', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'farm_adventure_resort_service_text', 
        array(
            'label'       => __('Section Text', 'farm-adventure-resort'),
            'section'     => 'farm_adventure_resort_classes_section_settings',
            'settings'    => 'farm_adventure_resort_service_text',
            'type'        => 'text'
        )
    );

    // Number of Service Posts to Show
    $wp_customize->add_setting('farm_adventure_resort_service_post_count', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('farm_adventure_resort_service_post_count', array(
        'label'       => __('Number of Post to Show', 'farm-adventure-resort'),
        'description' => __('Add number and refresh the page.', 'farm-adventure-resort'),
        'section'     => 'farm_adventure_resort_classes_section_settings',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 0,
            'max'  => 12,
        )
    ));

    $farm_adventure_resort_featured_post = get_theme_mod('farm_adventure_resort_service_post_count', 0);

    for ( $farm_adventure_resort_i = 1; $farm_adventure_resort_i <= $farm_adventure_resort_featured_post; $farm_adventure_resort_i++ ) {
        
        // Service Section - Select Post.
        $wp_customize->add_setting(
            'farm_adventure_resort_service_content_post_' . $farm_adventure_resort_i,
            array(
                'sanitize_callback' => 'absint',
            )
        );

        $wp_customize->add_control(
            'farm_adventure_resort_service_content_post_' . $farm_adventure_resort_i,
            array(
                'label'           => esc_html__( 'Select Post ', 'farm-adventure-resort' ) . $farm_adventure_resort_i,
                'section'         => 'farm_adventure_resort_classes_section_settings',
                'settings'        => 'farm_adventure_resort_service_content_post_' . $farm_adventure_resort_i,
                'type'            => 'select',
                'choices'         => farm_adventure_resort_get_post_choices(),
            )
        );
        
        $wp_customize->add_setting('farm_adventure_resort_location' . $farm_adventure_resort_i, array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('farm_adventure_resort_location' . $farm_adventure_resort_i, array(
            'label'    => __('Add Location ', 'farm-adventure-resort'),
            'section'  => 'farm_adventure_resort_classes_section_settings',
            'type'     => 'text',
        ));

        $wp_customize->add_setting('farm_adventure_resort_regular_price'.$farm_adventure_resort_i,array(
            'default'	=> '',
            'sanitize_callback'	=> 'sanitize_text_field'
        ));	
        $wp_customize->add_control('farm_adventure_resort_regular_price'.$farm_adventure_resort_i,array(
            'label'	=> esc_html__( 'Add Price', 'farm-adventure-resort' ),
            'section'	=> 'farm_adventure_resort_classes_section_settings',
            'type'		=> 'text',
            'input_attrs' => array(
                'placeholder' => __( '$50.00', 'farm-adventure-resort' ),
            ),
        ));

        $wp_customize->add_setting('farm_adventure_resort_time' . $farm_adventure_resort_i, array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('farm_adventure_resort_time' . $farm_adventure_resort_i, array(
            'label'    => __('Add Time ', 'farm-adventure-resort'),
            'section'  => 'farm_adventure_resort_classes_section_settings',
            'type'     => 'text',
        ));

        $wp_customize->add_setting('farm_adventure_resort_guest' . $farm_adventure_resort_i, array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('farm_adventure_resort_guest' . $farm_adventure_resort_i, array(
            'label'    => __('Add Guest ', 'farm-adventure-resort'),
            'section'  => 'farm_adventure_resort_classes_section_settings',
            'type'     => 'text',
        ));

        $wp_customize->add_setting(
            'farm_adventure_resort_video_url' . $farm_adventure_resort_i,
            array( 
                'default' => '',
                'sanitize_callback' => 'esc_url_raw',
            )
        );
        
        $wp_customize->add_control(
            'farm_adventure_resort_video_url' . $farm_adventure_resort_i,
            array(
                'label' => esc_html__( 'Video URL', 'farm-adventure-resort' ),
                'section' => 'farm_adventure_resort_classes_section_settings',
                'type' => 'url',
            )
        );

    }

    /** Service Section End */

    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'farm_adventure_resort_footer_section',
        array(
            'title' => __( 'Footer Settings', 'farm-adventure-resort' ),
            'priority' => 70,
            'panel' => 'farm_adventure_resort_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('farm_adventure_resort_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'farm_adventure_resort_sanitize_choices',
    ));

    $wp_customize->add_control('farm_adventure_resort_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'farm-adventure-resort'),
        'section'  => 'farm_adventure_resort_footer_section',
        'settings' => 'farm_adventure_resort_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'farm-adventure-resort'),
		   '2'     => __('Two', 'farm-adventure-resort'),
		   '3'     => __('Three', 'farm-adventure-resort'),
		   '4'     => __('Four', 'farm-adventure-resort')
        ),
    ));

    /** Copyright Text */
    $wp_customize->add_setting(
        'farm_adventure_resort_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'farm_adventure_resort_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'farm-adventure-resort' ),
            'section' => 'farm_adventure_resort_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('farm_adventure_resort_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'farm_adventure_resort_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'farm-adventure-resort'),
                /* translators: 1: image width in pixels, 2: image height in pixels */
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'farm-adventure-resort'), 1024, 800),
                'section' => 'farm_adventure_resort_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
                'priority' => 100,
            )
        )
    );

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'farm_adventure_resort_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'farm_adventure_resort_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'farm-adventure-resort'),
                'section' => 'farm_adventure_resort_footer_section',
                'type' => 'color',
            )
        )
    );

    /** Scroll to top control */
    $wp_customize->add_setting( 
        'farm_adventure_resort_scroll_to_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'farm_adventure_resort_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'farm_adventure_resort_scroll_to_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'farm-adventure-resort' ),
            'section'     => 'farm_adventure_resort_footer_section',
            'type'        => 'checkbox',
        )
    );

     $wp_customize->add_setting('farm_adventure_resort_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Farm_Adventure_Resort_Changeable_Icon(
        $wp_customize,'farm_adventure_resort_scroll_icon',array(
        'label' => __('Scroll Top Icon','farm-adventure-resort'),
        'transport' => 'refresh',
        'section'   => 'farm_adventure_resort_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('farm_adventure_resort_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'farm_adventure_resort_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('farm_adventure_resort_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','farm-adventure-resort'),
        'section' => 'farm_adventure_resort_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','farm-adventure-resort'),
            'center-align' => __('Center Alignment','farm-adventure-resort'),
            'left-align' => __('Left Alignment','farm-adventure-resort'),
        ),
    ) );

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'farm_adventure_resort_404_section',
        array(
            'title' => __( '404 Page Settings', 'farm-adventure-resort' ),
            'priority' => 70,
            'panel' => 'farm_adventure_resort_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'farm-adventure-resort'),
        'section' => 'farm_adventure_resort_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'farm-adventure-resort'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'farm-adventure-resort'),
        'section' => 'farm_adventure_resort_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'farm-adventure-resort'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'farm-adventure-resort'),
        'section' => 'farm_adventure_resort_404_section',
    ));

}
add_action( 'customize_register', 'farm_adventure_resort_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function farm_adventure_resort_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $farm_adventure_resort_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $farm_adventure_resort_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'farm_adventure_resort_customizer', get_template_directory_uri() . '/js' . $farm_adventure_resort_build . '/customizer' . $farm_adventure_resort_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'farm_adventure_resort_customize_preview_js' );