<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package farm_adventure_resort
 */
$farm_adventure_resort_scroll_top  = get_theme_mod( 'farm_adventure_resort_scroll_to_top', true );
$farm_adventure_resort_footer_background = get_theme_mod('farm_adventure_resort_footer_background_image');
$farm_adventure_resort_footer_background_url = '';
if(!empty($farm_adventure_resort_footer_background)){
    $farm_adventure_resort_footer_background = absint($farm_adventure_resort_footer_background);
    $farm_adventure_resort_footer_background_url = wp_get_attachment_url($farm_adventure_resort_footer_background);
}

$farm_adventure_resort_footer_background_color = get_theme_mod('farm_adventure_resort_footer_background_color', 'var(--primary-color)'); // New line

$farm_adventure_resort_footer_background_style = '';
if (!empty($farm_adventure_resort_footer_background_url)) {
    $farm_adventure_resort_footer_background_style = ' style="background-image: url(\'' . esc_url($farm_adventure_resort_footer_background_url) . '\'); background-repeat: no-repeat; background-size: cover;"';
} else {
    $farm_adventure_resort_footer_background_style = ' style="background-color: ' . esc_attr($farm_adventure_resort_footer_background_color) . ';"'; // Updated line
}
?>

</div>
</div>
</div>
</div>

<footer class="site-footer" <?php echo $farm_adventure_resort_footer_background_style; ?>>
    <?php 
    $farm_adventure_resort_active_areas = get_theme_mod('farm_adventure_resort_footer_widget_areas', 4);
    if (
        is_active_sidebar('footer-1') ||
        is_active_sidebar('footer-2') ||
        is_active_sidebar('footer-3') ||
        is_active_sidebar('footer-4')
    ) : ?>
        <div class="footer-t">
            <div class="container">
                <div class="row">
                    <?php 
                    for ($farm_adventure_resort_i = 1; $farm_adventure_resort_i <= $farm_adventure_resort_active_areas; $farm_adventure_resort_i++) {

                        if (is_active_sidebar('footer-' . $farm_adventure_resort_i)) {

                            $farm_adventure_resort_col = 12 / $farm_adventure_resort_active_areas;

                            echo '<div class="col-xl-' . $farm_adventure_resort_col . ' col-lg-' . $farm_adventure_resort_col . ' col-md-6 col-sm-6">';
                            dynamic_sidebar('footer-' . $farm_adventure_resort_i);
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
            </div>
        </div>

    <?php else : ?>

        <!-- Default Widget Content -->
        <div class="footer-t">
            <div class="container">
                <div class="row">

                    <?php 
                    // Dynamic column width
                    $farm_adventure_resort_col = 12 / $farm_adventure_resort_active_areas;
                    ?>

                    <!-- Archive -->
                    <aside class="widget widget_archive col-xl-<?php echo $farm_adventure_resort_col; ?> col-lg-<?php echo $farm_adventure_resort_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Archive List', 'farm-adventure-resort'); ?></h2>
                        <ul><?php wp_get_archives('type=monthly'); ?></ul>
                    </aside>

                    <!-- Recent Posts -->
                    <aside class="widget widget_recent_posts col-xl-<?php echo $farm_adventure_resort_col; ?> col-lg-<?php echo $farm_adventure_resort_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Recent Posts', 'farm-adventure-resort'); ?></h2>
                        <ul>
                            <?php
                            $args = array('post_type' => 'post', 'posts_per_page' => 5);
                            $recent_posts = new WP_Query($args);
                            while ($recent_posts->have_posts()) : $recent_posts->the_post(); ?>
                                <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                            <?php endwhile; wp_reset_postdata(); ?>
                        </ul>
                    </aside>

                    <!-- Categories -->
                    <aside class="widget widget_categories col-xl-<?php echo $farm_adventure_resort_col; ?> col-lg-<?php echo $farm_adventure_resort_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Categories', 'farm-adventure-resort'); ?></h2>
                        <ul><?php wp_list_categories(array('title_li' => '')); ?></ul>
                    </aside>

                    <!-- Tags -->
                    <aside class="widget widget_tags col-xl-<?php echo $farm_adventure_resort_col; ?> col-lg-<?php echo $farm_adventure_resort_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Tags', 'farm-adventure-resort'); ?></h2>
                        <div class="tag-cloud"><?php wp_tag_cloud(); ?></div>
                    </aside>

                </div>
            </div>
        </div>

    <?php endif; ?>

    <?php do_action('farm_adventure_resort_footer'); ?>

    <?php if ($farm_adventure_resort_scroll_top) : ?>
        <a id="button">
            <i class="<?php echo esc_attr(get_theme_mod('farm_adventure_resort_scroll_icon', 'fas fa-arrow-up')); ?>"></i>
        </a>
    <?php endif; ?>

</footer>
</div>
</div>

<?php wp_footer(); ?>

</body>
</html>