<?php 
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */
$options = fairtimes_get_theme_options();
$class = has_post_thumbnail() ? 'has-post-thumbnail' : '';
$featured_image = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
?>

    <article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
        <div class="featured-image" style="background-image:url('<?php echo esc_url( $featured_image ); ?>');">
            <a href="<?php the_permalink(); ?>" class="post-thumbnail-link"></a>
            <span class="min-read"><?php echo fairtimes_time_interval(get_the_content()); echo esc_html__(' min to read', 'fairtimes'); ?></span>
        </div><!-- .featured-image-->

        <div class="entry-container">
            <div class="entry-meta">
                <span class="cat-links">
                <?php echo fairtimes_article_footer_meta(); ?>
                </span>
                <?php fairtimes_posted_on($post->ID);  ?>
            </div>
            <header class="entry-header">
                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            </header>
            <div class="entry-content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-content -->
            <?php echo fairtimes_author(); ?>
        </div><!-- .entry-container -->
    </article>

