<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */
$options = fairtimes_get_theme_options();
$class = has_post_thumbnail() ? 'has-post-thumbnail' : '';
?>

	<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
		<?php if( has_post_thumbnail() ) : ?>
		<div class="featured-image">
			<img src="<?php the_post_thumbnail_url( 'large' ); ?>">
			<span class="min-read"><?php echo fairtimes_time_interval(get_the_content()); echo esc_html__(' min to read', 'fairtimes'); ?></span>
		</div><!-- .featured-image-->
		<?php endif; ?>

		<div class="entry-container">
			
			<div class="entry-meta">
                <span class="cat-links">
                <?php echo fairtimes_single_categories(); ?>
				</span>
				<?php fairtimes_posted_on($post->ID);  ?>
            </div>

			<header class="entry-header">
				<h2 class="entry-title"><?php the_title(); ?></h2>
			</header>

		<div class="entry-content">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'fairtimes' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'fairtimes' ),
				'after'  => '</div>',
			) );
		?>
		</div>
    </div><!-- .entry-container -->

	<?php
		echo fairtimes_author();

	fairtimes_entry_footer(); 
	?>
</article><!-- #post-## -->
