<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */
$class = has_post_thumbnail() ? 'has-post-thumbnail' : '';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>

    <div class="post-wrapper">
    	<?php if( has_post_thumbnail() ) : ?>
    		<div class="featured-image">
    			<img src="<?php the_post_thumbnail_url( 'large' ); ?>">
    			<span class="min-read"><?php echo fairtimes_time_interval(get_the_content()); echo esc_html__(' min to read', 'fairtimes'); ?></span>
    		</div><!-- .featured-image-->
    	<?php endif; ?>

    	<?php if ( fairtimes_is_frontpage() ) : ?>
    		<header class="entry-header">
    			<?php the_title( '<h2 class="entry-title">', '</h2>' ); ?>
    		</header><!-- .entry-header -->
    	<?php endif; ?>

    	<div class="entry-container">

			<div class="entry-content">
				<?php
					the_content();

					wp_link_pages( array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'fairtimes' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->

			<?php if ( get_edit_post_link() ) : ?>
				<footer class="entry-footer">
					<?php
						edit_post_link(
							sprintf(
								/* translators: %s: Name of current post */
								esc_html__( 'Edit %s', 'fairtimes' ),
								the_title( '<span class="screen-reader-text">"', '"</span>', false )
							),
							'<span class="edit-link">',
							'</span>'
						);
					?>
				</footer><!-- .entry-footer -->
			<?php endif; ?>
		</div><!-- .entry-container -->
	</div><!-- .post-wrapper -->
</article><!-- #post-## -->
