<?php
/**
 * Posts Filter Widget
 *
 * @package Theme Palace
 * @subpackage Greatnews Pro
 * @since Greatnews Pro 1.0.0
 */

if ( ! class_exists( 'fairtimes_Post_Filter' ) ) :


     class Fairtimes_Post_Filter extends WP_Widget {
        /**
         * Sets up the widgets name etc
         */
        public function __construct() {
            $tp_widget_posts_filter = array(
                'classname'   => 'recent-news',
                'description' => esc_html__( 'Retrive Posts Filter.', 'fairtimes' ),
                );
            parent::__construct( 'fairtimes_post_filter', esc_html__( 'TP : Posts Filter', 'fairtimes' ), $tp_widget_posts_filter );
        }

        /**
         * Outputs the content of the widget
         *
         * @param array $args
         * @param array $instance
         */
        public function widget( $args, $instance ) {
            
            $tp_category = isset( $instance ) ? $instance : ''; 

            ?>

            <section id="recent-news" class="widget widget_posts_filter">
                <div class="widget-header">
                    <h2 class="widget-title">
                        <?php
                        $i = 1;
                        foreach ( $tp_category as $category => $value ) :
                            ?>
                            <span data-tab="<?php echo esc_attr( strtolower( $value ) ) ;?>" class="<?php echo $i == 1 ? 'active': '' ?>"><?php echo esc_html(strtoupper($value)) ; ?></span>
                            <?php $i++;
                        endforeach; ?>
                    </h2>
                </div><!-- .widget-header -->
                 <?php
                    $i = 1 ; 
                    foreach ( $tp_category as $category => $value ) {
                    ?>

                <div id="<?php echo esc_attr( strtolower( $value ) ) ?>" class="tab-content <?php echo $i == 1 ? 'active': '' ?>">
                    <ul>
                    <?php 
                            $cat_id = get_cat_ID( strtolower( $value ) ) ;
                            $args = array(
                                'post_type'         => 'post',
                                'posts_per_page'    => 4,
                                'cat'               => absint( $cat_id ),
                                );
                            $query = new WP_Query( $args );
                            if ( $query->have_posts() ) : 
                                while ( $query->have_posts() ) : $query->the_post(); 

                            $image = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
                            ?>
                        <li>
                            <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($image); ?>" alt="<?php the_title(); ?>"></a>
                            <div class="entry-container">
                                <?php fairtimes_posted_on(); ?>
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                </header>
                            </div><!-- .entry-container -->
                        </li>

                       <?php endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </ul>
                </div><!-- #latest -->

                <?php
                      $i++;  
                    }
                 ?>  

            </section><!-- #recent-news -->
           

        <?php
           
            
        }

        /**
         * Outputs the options form on admin
         *
         * @param array $instance The widget options
         */
        public function form( $instance ) {

           printf (
                '<select multiple="multiple" name="%s[]" id="%s" class="widefat" size="15" style="margin-bottom:10px; margin-top:10px;">',
                esc_attr( $this->get_field_name('ID_list') ),
                esc_attr( $this->get_field_id('ID_list') )
            );
            $i = 1;
            // Each individual option
            foreach( fairtimes_category_choices() as $id )
            {
                printf(
                    '<option value="%s" %s style="margin-bottom:3px;" %s>%s</option>',
                    esc_attr($id),
                    in_array( $id, $instance) ? 'selected="selected"' : '',
                    $i == 1 ? 'disabled' : '',
                    esc_html($id)
                );
                $i++;
            }

            echo '</select>';
    }

        /**
        * Processing widget options on save
        *
        * @param array $new_instance The new options
        * @param array $old_instance The previous options
        */
       function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance = esc_sql( $new_instance['ID_list'] );
        return $instance;
    }
    }
    endif;
