<?php
/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

$options = fairtimes_get_theme_options();


if ( ! function_exists( 'fairtimes_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since Fairtimes 1.0.0
	 */
	function fairtimes_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>>
	<?php
	}
endif;

add_action( 'fairtimes_doctype', 'fairtimes_doctype', 10 );


if ( ! function_exists( 'fairtimes_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
		<?php endif;
	}
endif;
add_action( 'fairtimes_before_wp_head', 'fairtimes_head', 10 );

if ( ! function_exists( 'fairtimes_page_start' ) ) :
	/**
	 * Page starts html codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_page_start() {
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'fairtimes' ); ?></a>
			<div class="menu-overlay"></div>

		<?php
	}
endif;
add_action( 'fairtimes_page_start_action', 'fairtimes_page_start', 10 );

if ( ! function_exists( 'fairtimes_page_end' ) ) :
	/**
	 * Page end html codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_page_end() {
		?>
		</div><!-- #page -->
		<?php
	}
endif;
add_action( 'fairtimes_page_end_action', 'fairtimes_page_end', 10 );

if ( ! function_exists( 'fairtimes_header_start' ) ) :
	/**
	 * Header start html codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_header_start() { ?>
		<header id="masthead" class="site-header" role="banner">
		<?php
	}
endif;
add_action( 'fairtimes_header_action', 'fairtimes_header_start', 10 );

if ( ! function_exists( 'fairtimes_site_branding' ) ) :
	/**
	 * Site branding codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_site_branding() {
		$options  = fairtimes_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];		
		?>
		<div class="site-branding-container">
			<div class="wrapper">
				<div class="site-branding-wrapper">
					<div class="site-branding">
						<?php if ( in_array( $header_txt_logo_extra, array( 'show-all', 'logo-title', 'logo-tagline' ) )  ) { ?>
							<div class="site-logo">
								<?php the_custom_logo(); ?>
							</div>
						<?php } 
						if ( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline' ) ) ) : ?>
						<div id="site-identity">
							<?php
							if( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title' ) )  ) {
								if ( fairtimes_is_latest_posts() || fairtimes_is_frontpage() ) : ?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php
								endif;
								} 
								if ( in_array( $header_txt_logo_extra, array( 'show-all', 'tagline-only', 'logo-tagline' ) ) ) {
									$description = get_bloginfo( 'description', 'display' );
									if ( $description || is_customize_preview() ) : ?>
										<p class="site-description">
											<?php echo esc_html( $description ); /* WPCS: xss ok. */ ?>
										</p>
									<?php
								endif; 
							}
							?>
						</div>
						<?php endif; ?>
					</div><!-- .site-branding -->
					<ul class="contact-info">
						<?php if( !empty( $options['contact_information_no'] ) ): ?>
							<li>
								<?php echo fairtimes_get_svg( array( 'icon' => 'phone' ) ); ?>
								<span><a href="tel:<?php echo esc_attr( $options['contact_information_no'] ); ?>">
									<?php echo esc_html( $options['contact_information_no'] ); ?></a>
								</span>
							</li>
						<?php endif;
						if( !empty( $options['contact_information_location'] ) ):
							?>
							<li class="location">
								<?php echo fairtimes_get_svg( array( 'icon' => 'location' ) ); ?>
								<span class="location"><?php echo esc_html( $options['contact_information_location'] ); ?></span>
							</li>
						<?php endif; ?>
					</ul><!-- .contact-info -->
					<?php if ( $options['advertisement_enable'] ) :
						do_action('fairtimes_advertisement');
					endif; ?>

					<?php 
					if( has_nav_menu( 'social' ) ):
						wp_nav_menu(  array(
							'theme_location' => 'social',
							'container' => 'div',
							'container_class' => 'social-icons',
							'echo' => true,
							'depth' => 1,
							'link_before' => '<span class="screen-reader-text">',
							'link_after' => '</span>',
							'fallback_cb' => false,
						) );
					endif;
					?>
				</div><!-- .site-branding-wrapper -->
			</div><!-- .wrapper -->
		</div>
	<?php
	}
endif;
add_action( 'fairtimes_header_action', 'fairtimes_site_branding', 20 );


if ( ! function_exists( 'fairtimes_site_navigation' ) ) :
	/**
	 * Site navigation codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_site_navigation() {
		$options = fairtimes_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];		
		?>
		<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
			<?php
			echo fairtimes_get_svg( array( 'icon' => 'menu' ) );
			echo fairtimes_get_svg( array( 'icon' => 'close' ) );
			?>			
		</button>
		<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
			<div class="wrapper">
				<?php
				$search  = '';
				$search .= '<li class="main-navigation-search">';
				$search .= get_search_form( $echo = false );
				$search .= '</div></li>';

	        		$defaults = array(
	        			'theme_location' => 'primary',
	        			'container' => false,
	        			'menu_class' => 'menu nav-menu',
	        			'menu_id' => 'primary-menu',
	        			'echo' => true,
	        			'fallback_cb' => 'fairtimes_menu_fallback_cb',
	        			'items_wrap' => '<ul id="%1$s" class="%2$s">' . '%3$s' . $search . '</ul>',
	        		);
	        	
	        		wp_nav_menu( $defaults );
	        	?>
        	</div><!-- .wrapper -->
		</nav><!-- #site-navigation -->
	<?php
	}
endif;
add_action( 'fairtimes_header_action', 'fairtimes_site_navigation', 30 );


if ( ! function_exists( 'fairtimes_header_end' ) ) :
	/**
	 * Header end html codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_header_end() {
		?>
		</header><!-- #masthead -->
		<?php
	}
endif;

add_action( 'fairtimes_header_action', 'fairtimes_header_end', 50 );

if ( ! function_exists( 'fairtimes_content_start' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_content_start() {
		?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action( 'fairtimes_content_start_action', 'fairtimes_content_start', 10 );

if ( ! function_exists( 'fairtimes_header_image' ) ) :
	/**
	 * Header Image codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_header_image() {
		$options  = fairtimes_get_theme_options();
		if ( fairtimes_is_frontpage() )
			return;
		$header_image = get_header_image();
		
		?>

    	<?php if ( is_singular() && $options['single_post_hide_banner'] == false ): ?>
    		<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	    		
	            <div class="overlay"></div>
	            <div class="header-wrapper">
		            <div class="wrapper">
		                <header class="page-header">
		                    <?php fairtimes_custom_header_banner_title(); ?>
		                </header>

		                <?php fairtimes_add_breadcrumb(); ?>
		            </div><!-- .wrapper -->
	            </div><!-- .header-wrapper -->
	        </div><!-- #page-site-header -->
    	<?php endif ?>
    	<?php if (is_singular() && $options['single_post_hide_banner'] == true): ?>
    		<div class="header-wrapper wrapper">
                <header class="page-header">
                    <?php fairtimes_custom_header_banner_title(); ?>
                </header>

                <?php fairtimes_add_breadcrumb(); ?>
            </div><!-- .header-wrapper -->
    	<?php endif ?>

    	<?php if ( ( is_archive() || is_home() ) && $options['hide_banner'] == false ): ?>
    		<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	    		
	            <div class="overlay"></div>
	            <div class="header-wrapper">
		            <div class="wrapper">
		                <header class="page-header">
		                    <?php fairtimes_custom_header_banner_title(); ?>
		                </header>

		                <?php fairtimes_add_breadcrumb(); ?>
		            </div><!-- .wrapper -->
	            </div><!-- .header-wrapper -->
	        </div><!-- #page-site-header -->
    	<?php endif ?>
    	<?php if ( ( is_archive() || is_home() ) && $options['hide_banner'] == true): ?>
    		<div class="header-wrapper wrapper">
                <header class="page-header">
                    <?php fairtimes_custom_header_banner_title(); ?>
                </header>

                <?php fairtimes_add_breadcrumb(); ?>
            </div><!-- .header-wrapper -->
    	<?php endif ?>

    	

	<?php
	}
endif;
add_action( 'fairtimes_header_image_action', 'fairtimes_header_image', 10 );

if ( ! function_exists( 'fairtimes_add_breadcrumb' ) ) :
	/**
	 * Add breadcrumb.
	 *
	 * @since Fairtimes 1.0.0
	 */
	function fairtimes_add_breadcrumb() {
		$options = fairtimes_get_theme_options();
		// Bail if Breadcrumb disabled.
		$breadcrumb = $options['breadcrumb_enable'];
		if ( false === $breadcrumb ) {
			return;
		}
		
		// Bail if Home Page.
		if ( fairtimes_is_frontpage() ) {
			return;
		}

		echo '<div id="breadcrumb-list">';
				/**
				 * fairtimes_simple_breadcrumb hook
				 *
				 * @hooked fairtimes_simple_breadcrumb -  10
				 *
				 */
				do_action( 'fairtimes_simple_breadcrumb' );
		echo '</div><!-- #breadcrumb-list -->';
		return;
	}
endif;

if ( ! function_exists( 'fairtimes_content_end' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_content_end() {
		?>
		<div class="double-border-line"></div>
		</div><!-- #content -->
		<?php
	}
endif;
add_action( 'fairtimes_content_end_action', 'fairtimes_content_end', 10 );

if ( ! function_exists( 'fairtimes_footer_start' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_footer_start() {
		?>
		<footer id="colophon" class="site-footer" role="contentinfo">
		<?php
	}
endif;
add_action( 'fairtimes_footer', 'fairtimes_footer_start', 10 );

if ( ! function_exists( 'fairtimes_footer_site_info' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_footer_site_info() {
		$options = fairtimes_get_theme_options();
		$theme_data = wp_get_theme();
		$search = array( '[the-year]', '[site-link]' );

        $replace = array( date( 'Y' ), '<a href="'. esc_url( home_url( '/' ) ) .'">'. esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a>' );

        $options['copyright_text'] = str_replace( $search, $replace, $options['copyright_text'] );

		$copyright_text = $options['copyright_text']; 
		?>
		<span class="double-border-line"></span>
		<div class="site-info">
            <div class="wrapper">
                <span>
                	<?php if (!empty( $copyright_text ) ):

                		echo fairtimes_santize_allow_tag( $copyright_text ); 
                		if ( function_exists( 'the_privacy_policy_link' ) ) {
                			the_privacy_policy_link( ' | ' );
                		}

                	endif; ?>

                	<?php echo esc_html__( ' All Rights Reserved | ', 'fairtimes' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'fairtimes' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>' ?>
            	</span>
            </div><!-- .wrapper -->    
        </div><!-- .site-info -->

		<?php
	}
endif;
add_action( 'fairtimes_footer', 'fairtimes_footer_site_info', 40 );

if ( ! function_exists( 'fairtimes_footer_scroll_to_top' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_footer_scroll_to_top() {
		$options  = fairtimes_get_theme_options();
		if ( true === $options['scroll_top_visible'] ) : ?>
			<div class="backtotop"><?php echo fairtimes_get_svg( array( 'icon' => 'up' ) ); ?></div>
		<?php endif;
	}
endif;
add_action( 'fairtimes_footer', 'fairtimes_footer_scroll_to_top', 40 );

if ( ! function_exists( 'fairtimes_footer_end' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_footer_end() {
		?>
		</footer>
		<?php
	}
endif;
add_action( 'fairtimes_footer', 'fairtimes_footer_end', 100 );

if ( ! function_exists( 'fairtimes_loader' ) ) :
	/**
	 * Start div id #loader
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_loader() {
		$options = fairtimes_get_theme_options();
		if ( $options['loader_enable'] ) { ?>

			<div id="loader">
            <div class="loader-container">
            	<?php if ( 'default' == $options['loader_icon'] ) : ?>
	                <div id="preloader">
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                </div>
	            <?php else :
	            	echo fairtimes_get_svg( array( 'icon' => esc_attr( $options['loader_icon'] ) ) );
	            endif; ?>
            </div>
        </div><!-- #loader -->
		<?php }
	}
endif;
add_action( 'fairtimes_before_header', 'fairtimes_loader', 10 );

if ( ! function_exists( 'fairtimes_advertisement' ) ) :
	/**
	 * Start div id #advertisement
	 *
	 * @since Fairtimes 1.0.0
	 *
	 */
	function fairtimes_advertisement() { 
		$options = fairtimes_get_theme_options();
		
		?>
		<?php if ( ! empty( $options['ads_image'] ) && ! empty( $options['ads_url'] ) ) : ?>
		<div class="site-advertisement">
			<a href="<?php echo esc_url( $options['ads_url'] ); ?>"><img src="<?php echo esc_url( $options['ads_image'] ); ?>"></a>
		</div><!-- .site-advertisement -->

		<?php endif; ?>

	<?php }
endif;

add_action( 'fairtimes_advertisement', 'fairtimes_advertisement', 20 );
