<?php 

$options = fairtimes_get_theme_options();
// Check if recent is enabled on frontpage
$popular_posts_enable = apply_filters( 'fairtimes_section_status', true, 'popular_posts_section_enable' );

if ( true !== $popular_posts_enable ) {
     return false;
}

$popular_posts_content_type  = $options['popular_posts_content_type'];
$popular_posts_count = ! empty( $options['popular_posts_count'] ) ? $options['popular_posts_count'] : 4;


$content = array();
switch ( $popular_posts_content_type ) {

    case 'post':
    $post_ids = array();

    for ( $i = 1; $i <= $popular_posts_count; $i++ ) {
        if ( ! empty( $options['popular_posts_content_post_' . $i] ) )
            $post_ids[] = $options['popular_posts_content_post_' . $i];
        
    }
    // return if no post where selected
    if ( empty( $post_ids ) ) {
       return false;
    }

    $args = array(
        'post_type'         => 'post',
        'post__in'          => ( array ) $post_ids,
        'posts_per_page'    => absint( 4 ),
        'orderby'           => 'post__in',
        'ignore_sticky_posts'   => true,
        );                    
    break;

    case 'category':
    $cat_ids = ! empty( $options['popular_posts_content_category'] ) ? $options['popular_posts_content_category'] : '';
    $args = array(
        'post_type'         => 'post',
        'posts_per_page'    => absint( 4 ),
        'cat'               => absint( $cat_ids ),
        'ignore_sticky_posts'   => true,
        );                    
    break;

    default:
    break;
}

// Run The Loop.
$query = new WP_Query( $args );
if ( $query->have_posts() ) : 
    while ( $query->have_posts() ) : $query->the_post();
$page_post['id']        = get_the_id();
$page_post['title']     = get_the_title();
$page_post['url']       = get_the_permalink();
$page_post['excerpt']   = fairtimes_trim_content( 35 );
$page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

// Push to the main array.
array_push( $content, $page_post );
endwhile;
endif;
wp_reset_postdata();

if ( ! empty( $content ) ) {
    $input = $content;
}

// enable load more button
$enable_load_more_btn = '';
if ( $options['popular_posts_content_type'] == 'post' ) :
   $enable_load_more_btn = count( $post_ids );
elseif ( $options['popular_posts_content_type'] == 'category' ) :
   $enable_load_more_btn = $popular_posts_count;
endif;

?>
<div id="fairtimes_popular_posts_section" class="popular-posts-section list-layout">
    <div id="magazine-popular-posts">
        <?php if ( is_customize_preview()):
            fairtimes_section_tooltip( 'popular-posts-section-class' );
        endif; ?>  
        <div class="section-header">
            <?php if ( ! empty( $options['popular_posts_title'] ) ) : ?>
                <h2 class="section-title"><?php echo esc_html( $options['popular_posts_title'] ); ?></h2>
            <?php endif; ?>
        </div><!-- .section-header -->
        <div class="section-content clear popular-posts-wrapper">
            <?php foreach($input as $content) : ?>
                <article class="has-post-thumbnail">
                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                    </div><!-- .featured-image -->

                    <div class="entry-container">
                        <div class="entry-meta">
                            <span class="cat-links">
                                <?php the_category( '', '', $content['id'] ) ?>
                            </span><!-- .cat-links -->
                            <?php fairtimes_posted_on( $content['id'] ); ?>
                            <?php echo fairtimes_author( $content['id'] ); ?>
                        </div><!-- .entry-meta -->
                         <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                        </header>
                        <div class="entry-content">
                            <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                        </div><!-- .entry-content -->
                    </div><!-- .entry-container -->
                </article>
            <?php endforeach; ?>
        </div>
        <?php if ( $enable_load_more_btn > 4 ) : ?>
            <div class="load-more text-center" style="margin-top: 25px;">
                <a href="javascript:void(0)" class="btn btn-link" id="load-more" data-paged='2' ><?php echo esc_html__( 'Load More', 'fairtimes' ); ?></a>
            </div>
        <?php endif; ?>
    </div><!-- #recent-posts -->
</div>
