<?php
/**
 * Most Popular Section
 *
 * This is the template for the content of Most Popular section
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */
if ( ! function_exists( 'fairtimes_add_most_popular_section' ) ) :
    /**
    * Add Most Popular section
    *
    *@since Fairtimes 1.0.0
    */
    function fairtimes_add_most_popular_section() {
    	$options = fairtimes_get_theme_options();
        // Check if Most Popular is enabled on frontpage
        $most_popular_enable = apply_filters( 'fairtimes_section_status', true, 'most_popular_section_enable' );

        if ( true !== $most_popular_enable ) {
            return false;
        }
        // Get Most Popular section details
        $section_details = array();
        $section_details = apply_filters( 'fairtimes_filter_most_popular_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Most Popular section now.
        fairtimes_render_most_popular_section( $section_details );
    }
endif;

if ( ! function_exists( 'fairtimes_get_most_popular_section_details' ) ) :
    /**
    * Most Popular section details.
    *
    * @since Fairtimes 1.0.0
    * @param array $input Most Popular section details.
    */
    function fairtimes_get_most_popular_section_details( $input ) {
        $options = fairtimes_get_theme_options();

        // Content type.
        $most_popular_content_type  = $options['most_popular_content_type'];
        $most_popular_count = ! empty( $options['most_popular_count'] ) ? $options['most_popular_count'] : 6;
        
        $content = array();
        switch ( $most_popular_content_type ) {

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $most_popular_count; $i++ ) {
                    if ( ! empty( $options['most_popular_content_post_' . $i] ) )
                        $post_ids[] = $options['most_popular_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $most_popular_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['most_popular_content_category'] ) ? $options['most_popular_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $most_popular_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['auth_id']   = get_the_author_meta('ID');
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = fairtimes_trim_content( 35 );
                    $page_post['content']   = get_the_content();
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Most Popular section content details.
add_filter( 'fairtimes_filter_most_popular_section_details', 'fairtimes_get_most_popular_section_details' );


if ( ! function_exists( 'fairtimes_render_most_popular_section' ) ) :
  /**
   * Start Most Popular section
   *
   * @return string Most Popular content
   * @since Fairtimes 1.0.0
   *
   */
   function fairtimes_render_most_popular_section( $content_details = array() ) {
        $options = fairtimes_get_theme_options();
        $title = ! empty( $options['most_popular_title'] ) ? $options['most_popular_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } 
        $content = array_shift($content_details); ?>
        <div id="fairtimes_most_popular_section" class="most-popular-section relative grid-layout">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    fairtimes_section_tooltip( 'most-popular-section-class' );
                endif; ?>
                <div class="section-header">
                    <?php if( !empty( $title ) ): ?>
                        <h2 class="section-title"><?php echo esc_html( $title ); ?></h2>
                    <?php endif; ?>
                </div><!-- .section-header -->
                <div class="most-popular-wrapper col-3 clear">
                    <div class="half-width grid-layout">
                        <article class="has-post-thumbnail">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                            </div><!-- .featured-image -->
                            <div class="entry-container">
                                <div class="entry-meta">
                                    <span class="cat-links">
                                        <?php the_category( '', '', $content['id'] ); ?>
                                    </span><!-- .cat-links -->
                                    <?php fairtimes_posted_on( $content['id'] ); ?>
                                    <?php echo fairtimes_author( $content['id'] ); ?>
                                </div><!-- .entry-meta -->
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>
                                <div class="entry-content">
                                    <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                </div><!-- .entry-content -->
                            </div><!-- .entry-container -->
                        </article>
                    </div>

                    <!-- half-with section -->
                    <?php
                    $contents = array_slice($content_details, 0, 2);
                    ?>
                    <div class="half-width widget_most_popular">
                        <ul>
                            <?php foreach ($contents as $content): ?>   
                            <li>
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div>
                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span><!-- .cat-links -->
                                        <?php fairtimes_posted_on( $content['id'] ); ?>
                                    </div><!-- .entry-meta -->
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </li>
                            <?php endforeach ?>
                        </ul>
                    </div><!-- .half-width -->

                    <!-- half-width three-column most popular section -->
                    <div class="half-width widget_most_popular three-column">
                        <ul>
                            <?php
                            $contents = array_slice($content_details, 2);
                            foreach ($contents as $content): ?>  
                            <li>
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div>
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span><!-- .cat-links -->
                                        <?php fairtimes_posted_on( $content['id'] ); ?>
                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </li>
                            <?php endforeach ?>
                        </ul>
                    </div><!-- .half-width -->
                </div><!-- .most-popular-wrapper -->
            </div><!-- wrapper -->
        </div><!-- #fairtimes_most_popular_section -->
        
    <?php }
endif;