<?php 

/**
* Main posts wrapper section
*
* This is the template for the content of about section
*
* @package Theme Palace
* @subpackage Fairtimes
* @since Fairtimes 1.0.0
*/

if ( ! function_exists( 'fairtimes_add_main_posts_wrapper_section' ) ) :
/**
* Add recent section
*
*@since Fairtimes 1.0.0
*/
function fairtimes_add_main_posts_wrapper_section() {
    $options = fairtimes_get_theme_options();
?>
    <div id="main-post-wrapper" class="wrapper">
        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">
                <?php  
                // latest post section
                require get_template_directory() . '/inc/sections/latest-posts.php';
                fairtimes_add_latest_posts_section();

                // popular post section
                require get_template_directory() . '/inc/sections/popular-posts.php';
                ?>
            </main>
        </div><!-- #primary -->
        <?php if(is_active_sidebar('main-right-sidebar')): ?>
        <aside id="secondary" class="widget-area right-sidebar" role="complementary">
            <?php dynamic_sidebar( 'main-right-sidebar' ); ?>
        </aside><!-- #secondary -->
      <?php endif; ?>
    </div><!-- #inner-content-wrapper -->

<?php }
endif;