<?php 
if ( ! function_exists( 'fairtimes_add_latest_posts_section' ) ) :

    function fairtimes_add_latest_posts_section(){

        $options = fairtimes_get_theme_options();
        // Check if recent is enabled on frontpage
        $latest_posts_enable = apply_filters( 'fairtimes_section_status', true, 'latest_posts_section_enable' );

        if ( true !== $latest_posts_enable ) {
             return false;
        }

        $content = array();

        $cat_id = ! empty( $options['latest_posts_content_category'] ) ? $options['latest_posts_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => absint( 4 ),
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
        $page_post['id']        = get_the_id();
        $page_post['title']     = get_the_title();
        $page_post['url']       = get_the_permalink();
        $page_post['excerpt']   = fairtimes_trim_content( 60 );
        $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

        // Push to the main array.
        array_push( $content, $page_post );
        endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }

        ?>
        <div id="fairtimes_latest_posts_section" class="latest-posts-section relative">
            <?php if ( is_customize_preview()):
                fairtimes_section_tooltip( 'latest-posts-section-class' );
            endif; ?>   
            <div class="section-header">
                <?php if ( ! empty( $options['latest_posts_title'] ) ) : ?>
                    <h2 class="section-title"><?php echo esc_html( $options['latest_posts_title'] ); ?></h2>
                <?php endif; ?>
            </div><!-- .section-header -->
            <div class="section-content col-2 clear">
                <?php foreach($input as $content) : ?>
                    <article class="has-post-thumbnail">
                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                            <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                        </div><!-- .featured-image -->

                        <div class="entry-container">
                            <div class="entry-meta">
                                <span class="cat-links">
                                    <?php the_category( '', '', $content['id'] ) ?>
                                </span><!-- .cat-links -->
                                <?php fairtimes_posted_on( $content['id'] ); ?>
                                <?php echo fairtimes_author( $content['id'] ); ?>
                            </div><!-- .entry-meta -->
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                            </header>
                            <div class="entry-content">
                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                            </div><!-- .entry-content -->
                        </div><!-- .entry-container -->
                    </article>
                <?php endforeach; ?>
            </div><!-- .section-content -->
        </div><!-- #fairtimes_latest_posts_section -->
    <?php
    }
endif;
