<?php
/**
 * Header Posts Section
 *
 * This is the template for the content of Header Posts section
 *
 * @package Theme Palace
 * @subpackage Power News Pro
 * @since Power News Pro 1.0.0
 */
if ( ! function_exists( 'fairtimes_add_header_posts_section' ) ) :
    /**
    * Add Header Posts section
    *
    *@since Power News Pro 1.0.0
    */
    function fairtimes_add_header_posts_section() {
    	$options = fairtimes_get_theme_options();
        // Check if Header Posts is enabled on frontpage
        $header_posts_enable = apply_filters( 'fairtimes_section_status', true, 'header_posts_section_enable' );

        if ( true !== $header_posts_enable ) {
            return false;
        }
        // Get Header Posts section details
        $section_details = array();
        $section_details = apply_filters( 'fairtimes_filter_header_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Header Posts section now.
        fairtimes_render_header_posts_section( $section_details );
    }
endif;

if ( ! function_exists( 'fairtimes_get_header_posts_section_details' ) ) :
    /**
    * Header Posts section details.
    *
    * @since Power News Pro 1.0.0
    * @param array $input Header Posts section details.
    */
    function fairtimes_get_header_posts_section_details( $input ) {
        $options = fairtimes_get_theme_options();
        
        $content = array();
        $cat_id = ! empty( $options['header_posts_content_category'] ) ? $options['header_posts_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => absint( 6 ),
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['auth_id']   = get_the_author_meta('ID');
                $page_post['title']     = get_the_title();
                $page_post['content']   = get_the_content();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Header Posts section content details.
add_filter( 'fairtimes_filter_header_posts_section_details', 'fairtimes_get_header_posts_section_details' );


if ( ! function_exists( 'fairtimes_render_header_posts_section' ) ) :
  /**
   * Start Header Posts section
   *
   * @return string Header Posts content
   * @since Power News Pro 1.0.0
   *
   */
   function fairtimes_render_header_posts_section( $content_details = array() ) {
        $options = fairtimes_get_theme_options();
        $title = ! empty( $options['header_posts_title'] ) ? $options['header_posts_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

            <div id="fairtimes_header_posts_section" class="header-posts-section relative col-2 page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        fairtimes_section_tooltip( 'header-posts-section-class' );
                    endif; ?>
                    <div class="header-side-post">
                        <ul class="tabs header-posts-nav">
                            <?php $i = 1; foreach ($content_details as $content): $active = ( $i == 1 ) ? 'active' : ''; ?>
                            <li data-tab="header-post-<?php echo esc_attr( $content['id'] ); ?>" class="<?php echo esc_attr( $active ); ?>">
                                <article>
                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <?php the_category( '', '', $content['id'] ); ?>
                                            </span><!-- .cat-links -->

                                           <?php fairtimes_posted_on( $content['id'] ); ?>
                                        </div>
                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['content'] ); ?></p>
                                        </div>
                                    </div>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                        <a href="#" class="post-thumbnail-link"></a>
                                    </div>
                                </article>
                            </li>
                            <?php $i++; endforeach; ?>     
                        </ul>
                    </div><!-- .header-side-post -->
                    <div class="header-post">
                        <?php $i = 1; foreach ($content_details as $content): $count = ( $i == 1 ) ? 'active' : ''; ?>
                            <div id="header-post-<?php echo esc_attr( $content['id'] ); ?>" class="tab-content <?php echo esc_attr( $count ); ?>">
                                <article>
                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <?php the_category( '', '', $content['id'] ); ?>
                                            </span><!-- .cat-links -->

                                             <?php fairtimes_posted_on( $content['id'] ); ?>
                                        </div>
                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['content'] ); ?></p>
                                        </div>
                                    </div>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                    </div>
                                </article>
                            </div>
                        <?php $i++; endforeach; ?> 
                    </div><!-- .header-post -->
                </div><!-- .wrapper -->
            </div><!-- #fairtimes_header_posts_section -->
    <?php }
endif;