<?php
/**
 * Featured Article Section
 *
 * This is the template for the content of Featured Article section
 *
 * @package Theme Palace
 * @subpackage Power News Pro
 * @since Power News Pro 1.0.0
 */
if ( ! function_exists( 'fairtimes_add_featured_article_section' ) ) :
    /**
    * Add Featured Article section
    *
    *@since Power News Pro 1.0.0
    */
    function fairtimes_add_featured_article_section() {
    	$options = fairtimes_get_theme_options();
        // Check if Featured Article is enabled on frontpage
        $featured_article_enable = apply_filters( 'fairtimes_section_status', true, 'featured_article_section_enable' );

        if ( true !== $featured_article_enable ) {
            return false;
        }
        // Get Featured Article section details
        $section_details = array();
        $section_details = apply_filters( 'fairtimes_filter_featured_article_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Featured Article section now.
        fairtimes_render_featured_article_section( $section_details );
    }
endif;

if ( ! function_exists( 'fairtimes_get_featured_article_section_details' ) ) :
    /**
    * Featured Article section details.
    *
    * @since Power News Pro 1.0.0
    * @param array $input Featured Article section details.
    */
    function fairtimes_get_featured_article_section_details( $input ) {
        $options = fairtimes_get_theme_options();

        // Content type.        
        $content = array();
        $cat_id = ! empty( $options['featured_article_content_category'] ) ? $options['featured_article_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => absint( 3 ),
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['auth_id']   = get_the_author_meta('ID');
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = fairtimes_trim_content( 35 );
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Featured Article section content details.
add_filter( 'fairtimes_filter_featured_article_section_details', 'fairtimes_get_featured_article_section_details' );


if ( ! function_exists( 'fairtimes_render_featured_article_section' ) ) :
  /**
   * Start Featured Article section
   *
   * @return string Featured Article content
   * @since Power News Pro 1.0.0
   *
   */
   function fairtimes_render_featured_article_section( $content_details = array() ) {
        $options = fairtimes_get_theme_options();
        $title = ! empty( $options['featured_article_title'] ) ? $options['featured_article_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="fairtimes_featured_article_section" class="featured-article-section page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    fairtimes_section_tooltip( 'featured-article-section-class' );
                endif; ?>
                <div class="section-header">
                    <?php if( !empty( $title ) ): ?>
                        <h2 class="section-title"><?php echo esc_html( $title ); ?></h2>
                    <?php endif; ?>
                </div><!-- .section-header -->

                <div class="section-content col-3">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="has-post-thumbnail">
                            <div class="featured-wrapper">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div><!-- .featured-image -->
                                <div class="entry-container">
                                    <div class="header-wrapper">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <?php the_category( '', '', $content['id'] ); ?>
                                            </span><!-- .cat-links -->
                                            <?php fairtimes_posted_on( $content['id'] ); ?>
                                        </div><!-- .entry-meta -->
                                    </div><!-- .header-wrapper -->
                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div>
                                </div><!-- .entry-container -->
                            </div><!-- .featured-wrapper -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .section-conten -->
            </div><!-- .wrapper -->
        </div><!-- #fairtimes_featured_article_section -->  
    <?php }
endif;