<?php
/**
 * Breaking News section
 *
 * This is the template for the content of Breaking News section
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */
if ( ! function_exists( 'fairtimes_add_breaking_news_section' ) ) :
    /**
    * Add Breaking News section
    *
    *@since Fairtimes 1.0.0
    */
    function fairtimes_add_breaking_news_section() {
    	$options = fairtimes_get_theme_options();
        // Check if Breaking News is enabled on frontpage
        $breaking_news_enable = apply_filters( 'fairtimes_section_status', true, 'breaking_news_section_enable' );
        if($options['home_layout'] == 'sixth-design'){
            $breaking_news_enable = false;
        }

        if ( true !== $breaking_news_enable ) {
            return false;
        }
        // Get Breaking News section details
        $section_details = array();
        $section_details = apply_filters( 'fairtimes_filter_breaking_news_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Breaking News section now.
        fairtimes_render_breaking_news_section( $section_details );
    }
endif;

if ( ! function_exists( 'fairtimes_get_breaking_news_section_details' ) ) :
    /**
    * Breaking News section details.
    *
    * @since Fairtimes 1.0.0
    * @param array $input Breaking News section details.
    */
    function fairtimes_get_breaking_news_section_details( $input ) {
        $options = fairtimes_get_theme_options();

        $content = array();
        $cat_id = ! empty( $options['breaking_news_content_category'] ) ? $options['breaking_news_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => 4,
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

// Breaking News section content details.
add_filter( 'fairtimes_filter_breaking_news_section_details', 'fairtimes_get_breaking_news_section_details' );

if ( ! function_exists( 'fairtimes_render_breaking_news_section' ) ) :
  /**
   * Start Breaking News section
   *
   * @return string Breaking News content
   * @since Fairtimes 1.0.0
   *
   */
   function fairtimes_render_breaking_news_section( $content_details = array() ) {
        $options = fairtimes_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        ?>

        <div id="fairtimes_breaking_news_section" class="breaking-news-section relative same-background">
            <div class="wrapper">
                <div class="breaking-news-wrapper">
                    <?php if ( is_customize_preview()):
                        fairtimes_section_tooltip( 'breaking-news-section-class' );
                    endif; ?>
                    <h2 class="news-title"><?php echo esc_html($options['breaking_news_title']); ?></h2>
                    <div class="breaking-news-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":false, "autoplay": true, "draggable": true, "fade": false }'>
                        <?php foreach($content_details as $post):?>
                            <article>
                                <div class="breaking-news-item-wrapper">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($post['url']); ?>"><?php echo esc_html($post['title']); ?></a></h2>
                                    </header>
                                </div><!-- .breaking-news-item-wrapper -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .breaking-news-slider -->
                </div><!-- .breaking-news-wrapper -->
            </div><!-- wrapper -->
        </div><!-- #fairtimes_breaking_news_section -->
    <?php }
endif;