<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function fairtimes_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function fairtimes_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function fairtimes_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}

function fairtimesduct_choices() {
    $full_product_list = array();
    $product_id = array();
    $loop = new WP_Query(array('post_type' => array('product', 'product_variation'), 'posts_per_page' => -1));
    while ($loop->have_posts()) : $loop->the_post();
        $product_id[] = get_the_id();
    endwhile;
    wp_reset_postdata();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $product_id  as $id ) {
        $choices[ $id ] = get_the_title( $id );
    }
    return  $choices;
}

/**
 * List of trips for post choices.
 * @return Array Array of post ids and name.
 */
function fairtimes_trip_choices() {
    $posts = get_posts( array( 'post_type' => 'itineraries', 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of events for post choices.
 * @return Array Array of post ids and name.
 */
function fairtimes_event_choices() {
    $posts = get_posts( array( 'numberposts' => -1, 'post_type' => 'tp-event' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'fairtimes' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}


if ( ! function_exists( 'fairtimes_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function fairtimes_site_layout() {
        $fairtimes_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'fairtimes_site_layout', $fairtimes_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'fairtimes_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function fairtimes_selected_sidebar() {
        $fairtimes_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'fairtimes' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'fairtimes' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'fairtimes' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'fairtimes' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'fairtimes' ),
        );

        $output = apply_filters( 'fairtimes_selected_sidebar', $fairtimes_selected_sidebar );

        return $output;
    }
endif;

if ( ! function_exists( 'fairtimes_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function fairtimes_global_sidebar_position() {
        $fairtimes_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
        );

        $output = apply_filters( 'fairtimes_global_sidebar_position', $fairtimes_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'fairtimes_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function fairtimes_sidebar_position() {
        $fairtimes_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
        );

        $output = apply_filters( 'fairtimes_sidebar_position', $fairtimes_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'fairtimes_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function fairtimes_pagination_options() {
        $fairtimes_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'fairtimes' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'fairtimes' ),
        );

        $output = apply_filters( 'fairtimes_pagination_options', $fairtimes_pagination_options );

        return $output;
    }
endif;


if ( ! function_exists( 'fairtimes_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function fairtimes_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'fairtimes' ),
            'off'       => esc_html__( 'Disable', 'fairtimes' )
        );
        return apply_filters( 'fairtimes_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'fairtimes_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function fairtimes_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'fairtimes' ),
            'off'       => esc_html__( 'No', 'fairtimes' )
        );
        return apply_filters( 'fairtimes_hide_options', $arr );
    }
endif;






