<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Fairtimes
* @since Fairtimes 1.0.0
*/

if ( ! function_exists( 'fairtimes_validate_long_excerpt' ) ) :
  function fairtimes_validate_long_excerpt( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'fairtimes' ) );
     } elseif ( $value < 5 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'fairtimes' ) );
     } elseif ( $value > 100 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'fairtimes' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'fairtimes_validate_popular_posts_count' ) ) :
  function fairtimes_validate_popular_posts_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'fairtimes' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 1', 'fairtimes' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 12', 'fairtimes' ) );
     }
     return $validity;
  }
endif;