<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'fairtimes_single_post_section', array(
	'title'             => esc_html__( 'Single Post','fairtimes' ),
	'description'       => esc_html__( 'Options to change the single posts globally.', 'fairtimes' ),
	'panel'             => 'fairtimes_theme_options_panel',
) );

$wp_customize->add_setting( 'fairtimes_theme_options[single_post_hide_banner]', array(
	'default'           => $options['single_post_hide_banner'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[single_post_hide_banner]', array(
	'label'             => esc_html__( 'Hide Banner', 'fairtimes' ),
	'section'           => 'fairtimes_single_post_section',
	'on_off_label' 		=> fairtimes_hide_options(),
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[single_post_hide_category]', array(
	'default'           => $options['single_post_hide_category'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[single_post_hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'fairtimes' ),
	'section'           => 'fairtimes_single_post_section',
	'on_off_label' 		=> fairtimes_hide_options(),
) ) );