<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'fairtimes_reset_section', array(
	'title'             => esc_html__('Reset all settings','fairtimes'),
	'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'fairtimes' ),
) );

// Add reset enable setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[reset_options]', array(
	'default'           => $options['reset_options'],
	'sanitize_callback' => 'fairtimes_sanitize_checkbox',
	'transport'			  => 'postMessage',
) );

$wp_customize->add_control( 'fairtimes_theme_options[reset_options]', array(
	'label'             => esc_html__( 'Check to reset all settings', 'fairtimes' ),
	'section'           => 'fairtimes_reset_section',
	'type'              => 'checkbox',
) );
