<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'fairtimes_pagination', array(
	'title'               => esc_html__('Pagination','fairtimes'),
	'description'         => esc_html__( 'Pagination section options.', 'fairtimes' ),
	'panel'               => 'fairtimes_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'fairtimes' ),
	'section'             => 'fairtimes_pagination',
	'on_off_label' 		=> fairtimes_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'fairtimes_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'fairtimes_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'fairtimes' ),
	'section'             => 'fairtimes_pagination',
	'type'                => 'select',
	'choices'			  => fairtimes_pagination_options(),
	'active_callback'	  => 'fairtimes_is_pagination_enable',
) );
