<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'fairtimes_menu', array(
	'title'             => esc_html__('Header Menu','fairtimes'),
	'description'       => esc_html__( 'Header Menu options.', 'fairtimes' ),
	'panel'             => 'nav_menus',
) );

// team sub_title setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[contact_information_no]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'fairtimes_theme_options[contact_information_no]', array(
    'label'             => esc_html__( 'Contact Number', 'fairtimes' ),
    'section'           => 'fairtimes_menu',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[contact_information_no]', array(
        'selector'            => '#top-bar li.number',
        'settings'            => 'fairtimes_theme_options[contact_information_no]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'fairtimes_contact_information_no_partial',
    ) );
}
// team sub_title setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[contact_information_location]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'fairtimes_theme_options[contact_information_location]', array(
    'label'             => esc_html__( 'Address / Location', 'fairtimes' ),
    'section'           => 'fairtimes_menu',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[contact_information_location]', array(
        'selector'            => '#top-bar li.location',
        'settings'            => 'fairtimes_theme_options[contact_information_location]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'fairtimes_contact_information_location_partial',
    ) );
}

// ads image setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[ads_image]', array(
    'sanitize_callback' => 'fairtimes_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'fairtimes_theme_options[ads_image]',
        array(
        'label'             => esc_html__( 'Ads Image', 'fairtimes' ),
        'description'       => sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'fairtimes' ), 900, 100 ),
        'section'           => 'fairtimes_menu',
) ) );

// ads link setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[ads_url]', array(
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'fairtimes_theme_options[ads_url]', array(
    'label'             => esc_html__( 'Ads Url', 'fairtimes' ),
    'section'           => 'fairtimes_menu',
    'type'              => 'url',
) );