<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'fairtimes_layout', array(
	'title'               => esc_html__('Layout','fairtimes'),
	'description'         => esc_html__( 'Layout section options.', 'fairtimes' ),
	'panel'               => 'fairtimes_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[site_layout]', array(
	'sanitize_callback'   => 'fairtimes_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new Fairtimes_Custom_Radio_Image_Control ( $wp_customize, 'fairtimes_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'fairtimes' ),
	'section'             => 'fairtimes_layout',
	'choices'			  => fairtimes_site_layout(),
) ) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'fairtimes_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control(  new Fairtimes_Custom_Radio_Image_Control ( $wp_customize, 'fairtimes_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Global Sidebar Position', 'fairtimes' ),
	'section'             => 'fairtimes_layout',
	'choices'			  => fairtimes_global_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[post_sidebar_position]', array(
	'sanitize_callback'   => 'fairtimes_sanitize_select',
	'default'             => $options['post_sidebar_position'],
) );

$wp_customize->add_control(  new Fairtimes_Custom_Radio_Image_Control ( $wp_customize, 'fairtimes_theme_options[post_sidebar_position]', array(
	'label'               => esc_html__( 'Posts Sidebar Position', 'fairtimes' ),
	'section'             => 'fairtimes_layout',
	'choices'			  => fairtimes_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[page_sidebar_position]', array(
	'sanitize_callback'   => 'fairtimes_sanitize_select',
	'default'             => $options['page_sidebar_position'],
) );

$wp_customize->add_control( new Fairtimes_Custom_Radio_Image_Control( $wp_customize, 'fairtimes_theme_options[page_sidebar_position]', array(
	'label'               => esc_html__( 'Pages Sidebar Position', 'fairtimes' ),
	'section'             => 'fairtimes_layout',
	'choices'			  => fairtimes_sidebar_position(),
) ) );