<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'fairtimes_excerpt_section', array(
	'title'             => esc_html__( 'Excerpt','fairtimes' ),
	'description'       => esc_html__( 'Excerpt section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_theme_options_panel',
) );


// long Excerpt length setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[long_excerpt_length]', array(
	'sanitize_callback' => 'fairtimes_sanitize_number_range',
	'validate_callback' => 'fairtimes_validate_long_excerpt',
	'default'			=> $options['long_excerpt_length'],
) );

$wp_customize->add_control( 'fairtimes_theme_options[long_excerpt_length]', array(
	'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'fairtimes' ),
	'description' 		=> esc_html__( 'Note: Min 5 & Max 100. Total words to be displayed in archive page/search page.', 'fairtimes' ),
	'section'     		=> 'fairtimes_excerpt_section',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
	),
) );

