<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

$wp_customize->add_section( 'fairtimes_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','fairtimes' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'fairtimes' ),
	'section'          	=> 'fairtimes_breadcrumb',
	'on_off_label' 		=> fairtimes_switch_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'fairtimes_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'fairtimes' ),
	'active_callback' 	=> 'fairtimes_is_breadcrumb_enable',
	'section'          	=> 'fairtimes_breadcrumb',
) );
