<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage Businesszen Pro
 * @since Businesszen Pro 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'fairtimes_archive_section', array(
	'title'             => esc_html__( 'Blog/Archive','fairtimes' ),
	'description'       => esc_html__( 'Archive section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_theme_options_panel',
) );

$wp_customize->add_setting( 'fairtimes_theme_options[hide_banner]', array(
	'default'           => $options['hide_banner'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[hide_banner]', array(
	'label'             => esc_html__( 'Hide Banner', 'fairtimes' ),
	'section'           => 'fairtimes_archive_section',
	'on_off_label' 		=> fairtimes_hide_options(),
) ) );

// Archive category setting and control.
$wp_customize->add_setting( 'fairtimes_theme_options[hide_category]', array(
	'default'           => $options['hide_category'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'fairtimes' ),
	'section'           => 'fairtimes_archive_section',
	'on_off_label' 		=> fairtimes_hide_options(),
) ) );