<?php
/**
* Most Popular Section options
*
* @package Theme Palace
* @subpackage Power News
* @since Power News 1.0.0
*/

// Add Most Popular section
$wp_customize->add_section( 'fairtimes_most_popular_section', array(
	'title'             => esc_html__( 'Most Popular','fairtimes' ),
	'description'       => esc_html__( 'Most Popular Section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_front_page_panel',
) );

// Most Popular content enable control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[most_popular_section_enable]', array(
	'default'			=> 	$options['most_popular_section_enable'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
	) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[most_popular_section_enable]', array(
	'label'             => esc_html__( 'Most Popular Section Enable', 'fairtimes' ),
	'section'           => 'fairtimes_most_popular_section',
	'on_off_label' 		=> fairtimes_switch_options(),
	) ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[most_popular_section_enable]', array(
		'selector'      => '#fairtimes_most_popular_section .tooltiptext',
		'settings'      => 'fairtimes_theme_options[most_popular_section_enable]',
    ) );
}

// Most Popular title setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[most_popular_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['most_popular_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'fairtimes_theme_options[most_popular_title]', array(
	'label'           	=> esc_html__( 'Title', 'fairtimes' ),
	'section'        	=> 'fairtimes_most_popular_section',
	'active_callback' 	=> 'fairtimes_is_most_popular_section_enable',
	'type'				=> 'text',
	) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[most_popular_title]', array(
		'selector'            => '#fairtimes_most_popular_section h2.section-title',
		'settings'            => 'fairtimes_theme_options[most_popular_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'fairtimes_most_popular_title_partial',
    ) );
}

// Most Popular content type control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[most_popular_content_type]', array(
	'default'          	=> $options['most_popular_content_type'],
	'sanitize_callback' => 'fairtimes_sanitize_select',
	) );

$wp_customize->add_control( 'fairtimes_theme_options[most_popular_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'fairtimes' ),
	'section'           => 'fairtimes_most_popular_section',
	'type'				=> 'select',
	'active_callback' 	=> 'fairtimes_is_most_popular_section_enable',
	'choices'			=> array( 
		'post' 		=> esc_html__( 'Post', 'fairtimes' ),
		'category' 	=> esc_html__( 'Category', 'fairtimes' ),
		),
	) );

for ( $i = 1; $i <= 6; $i++ ) :

// Most Popular posts drop down chooser control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[most_popular_content_post_' . $i . ']', array(
	'sanitize_callback' => 'fairtimes_sanitize_page',
	) );

$wp_customize->add_control( new Fairtimes_Dropdown_Chooser( $wp_customize, 'fairtimes_theme_options[most_popular_content_post_' . $i . ']', array(
	'label'             => sprintf( esc_html__( 'Select Post %d', 'fairtimes' ), $i ),
	'section'           => 'fairtimes_most_popular_section',
	'choices'			=> fairtimes_post_choices(),
	'active_callback'	=> 'fairtimes_is_most_popular_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'fairtimes_theme_options[most_popular_content_category]', array(
	'sanitize_callback' => 'fairtimes_sanitize_single_category',
	) ) ;

$wp_customize->add_control( new Fairtimes_Dropdown_Taxonomies_Control( $wp_customize,'fairtimes_theme_options[most_popular_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'fairtimes' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'fairtimes' ),
	'section'           => 'fairtimes_most_popular_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'fairtimes_is_most_popular_section_content_category_enable'
	) ) );