<?php
/**
* Latest Posts Section options
*
* @package Theme Palace
* @subpackage Power News
* @since Power News 1.0.0
*/

// Add Latest Posts section
$wp_customize->add_section( 'fairtimes_latest_posts_section', array(
	'title'             => esc_html__( 'Latest Posts','fairtimes' ),
	'description'       => esc_html__( 'Latest Posts Section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_front_page_panel',
) );

// Latest Posts content enable control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[latest_posts_section_enable]', array(
	'default'			=> 	$options['latest_posts_section_enable'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
	) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[latest_posts_section_enable]', array(
	'label'             => esc_html__( 'Latest Posts Section Enable', 'fairtimes' ),
	'section'           => 'fairtimes_latest_posts_section',
	'on_off_label' 		=> fairtimes_switch_options(),
	) ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[latest_posts_section_enable]', array(
		'selector'      => '#fairtimes_latest_posts_section .tooltiptext',
		'settings'      => 'fairtimes_theme_options[latest_posts_section_enable]',
    ) );
}

// Latest Posts title setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[latest_posts_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['latest_posts_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'fairtimes_theme_options[latest_posts_title]', array(
	'label'           	=> esc_html__( 'Title', 'fairtimes' ),
	'section'        	=> 'fairtimes_latest_posts_section',
	'active_callback' 	=> 'fairtimes_is_latest_posts_section_enable',
	'type'				=> 'text',
	) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[latest_posts_title]', array(
		'selector'            => '#fairtimes_latest_posts_section h2.section-title',
		'settings'            => 'fairtimes_theme_options[latest_posts_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'fairtimes_latest_posts_title_partial',
    ) );
}

// Add dropdown category setting and control.
$wp_customize->add_setting(  'fairtimes_theme_options[latest_posts_content_category]', array(
	'sanitize_callback' => 'fairtimes_sanitize_single_category',
	) ) ;

$wp_customize->add_control( new Fairtimes_Dropdown_Taxonomies_Control( $wp_customize,'fairtimes_theme_options[latest_posts_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'fairtimes' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'fairtimes' ),
	'section'           => 'fairtimes_latest_posts_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'fairtimes_is_latest_posts_section_enable'
	) ) );