<?php
/**
* Header Posts Section options
*
* @package Theme Palace
* @subpackage Power News Pro
* @since Power News Pro 1.0.0
*/

// Add Header Posts section
$wp_customize->add_section( 'fairtimes_header_posts_section', array(
	'title'             => esc_html__( 'Header Posts','fairtimes' ),
	'description'       => esc_html__( 'Header Posts Section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_front_page_panel',
) );

// Header Posts content enable control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[header_posts_section_enable]', array(
	'default'			=> 	$options['header_posts_section_enable'],
	'sanitize_callback' => 'fairtimes_sanitize_switch_control',
	) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[header_posts_section_enable]', array(
	'label'             => esc_html__( 'Header Posts Section Enable', 'fairtimes' ),
	'section'           => 'fairtimes_header_posts_section',
	'on_off_label' 		=> fairtimes_switch_options(),
	) ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[header_posts_section_enable]', array(
		'selector'      => '#fairtimes_header_posts_section .tooltiptext',
		'settings'      => 'fairtimes_theme_options[header_posts_section_enable]',
    ) );
}



// Add dropdown category setting and control.
$wp_customize->add_setting(  'fairtimes_theme_options[header_posts_content_category]', array(
	'sanitize_callback' => 'fairtimes_sanitize_single_category',
	) ) ;

$wp_customize->add_control( new Fairtimes_Dropdown_Taxonomies_Control( $wp_customize,'fairtimes_theme_options[header_posts_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'fairtimes' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'fairtimes' ),
	'section'           => 'fairtimes_header_posts_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'fairtimes_is_header_posts_section_enable'
	) ) );